/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.extra.image.ImageKit;

public class QrConfig {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    protected int width;
    protected int height;
    protected Integer foreColor = -16777216;
    protected Integer backColor = -1;
    protected Integer margin = 2;
    protected Integer qrVersion;
    protected ErrorCorrectionLevel errorCorrection = ErrorCorrectionLevel.M;
    protected Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;
    protected Image img;
    protected double imgRound = 0.3;
    protected int ratio = 6;
    protected SymbolShapeHint shapeHint = SymbolShapeHint.FORCE_NONE;
    protected BarcodeFormat format = BarcodeFormat.QR_CODE;

    public QrConfig() {
        this(300, 300);
    }

    public QrConfig(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static QrConfig of() {
        return new QrConfig();
    }

    public static QrConfig of(int width, int height) {
        return new QrConfig(width, height);
    }

    public int getWidth() {
        return this.width;
    }

    public QrConfig setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public QrConfig setHeight(int height) {
        this.height = height;
        return this;
    }

    public Integer getForeColor() {
        return this.foreColor;
    }

    public QrConfig setForeColor(Color foreColor) {
        this.foreColor = null == foreColor ? null : Integer.valueOf(foreColor.getRGB());
        return this;
    }

    public Integer getBackColor() {
        return this.backColor;
    }

    public QrConfig setBackColor(Color backColor) {
        this.backColor = null == backColor ? null : Integer.valueOf(backColor.getRGB());
        return this;
    }

    public Integer getMargin() {
        return this.margin;
    }

    public QrConfig setMargin(Integer margin) {
        this.margin = margin;
        return this;
    }

    public Integer getQrVersion() {
        return this.qrVersion;
    }

    public QrConfig setQrVersion(Integer qrVersion) {
        this.qrVersion = qrVersion;
        return this;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        return this.errorCorrection;
    }

    public QrConfig setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        this.errorCorrection = errorCorrection;
        return this;
    }

    public void setEnableEci(boolean enableEci) {
        if (enableEci) {
            if (null == this.charset) {
                this.charset = org.miaixz.bus.core.lang.Charset.UTF_8;
            }
        } else {
            this.charset = null;
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public QrConfig setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Image getImg() {
        return this.img;
    }

    public QrConfig setImg(String imgPath) {
        return this.setImg(FileKit.file((String)imgPath));
    }

    public QrConfig setImg(byte[] imageBytes) {
        return this.setImg(ImageKit.toImage(imageBytes));
    }

    public QrConfig setImg(File imgFile) {
        return this.setImg(ImageKit.read(imgFile));
    }

    public QrConfig setImg(Image img) {
        this.img = img;
        return this;
    }

    public double getImgRound() {
        return this.imgRound;
    }

    public QrConfig setImgRound(double imgRound) {
        this.imgRound = imgRound;
        return this;
    }

    public int getRatio() {
        return this.ratio;
    }

    public QrConfig setRatio(int ratio) {
        this.ratio = ratio;
        return this;
    }

    public QrConfig setShapeHint(SymbolShapeHint shapeHint) {
        this.shapeHint = shapeHint;
        return this;
    }

    public BarcodeFormat getFormat() {
        return this.format;
    }

    public QrConfig setFormat(BarcodeFormat format) {
        this.format = format;
        return this;
    }

    public HashMap<EncodeHintType, Object> toHints() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        if (null != this.charset) {
            hints.put(EncodeHintType.CHARACTER_SET, this.charset.toString().toLowerCase());
        }
        if (null != this.errorCorrection) {
            Integer value = BarcodeFormat.AZTEC == this.format || BarcodeFormat.PDF_417 == this.format ? Integer.valueOf(this.errorCorrection.getBits()) : this.errorCorrection;
            hints.put(EncodeHintType.ERROR_CORRECTION, value);
            hints.put(EncodeHintType.DATA_MATRIX_SHAPE, this.shapeHint);
        }
        if (null != this.margin) {
            hints.put(EncodeHintType.MARGIN, this.margin);
        }
        if (null != this.qrVersion) {
            hints.put(EncodeHintType.QR_VERSION, this.qrVersion);
        }
        return hints;
    }
}

