/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode.render;

import com.google.zxing.common.BitMatrix;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.miaixz.bus.core.lang.ansi.AnsiElement;
import org.miaixz.bus.core.lang.ansi.AnsiEncoder;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ColorKit;
import org.miaixz.bus.extra.qrcode.QrConfig;
import org.miaixz.bus.extra.qrcode.render.BitMatrixRender;

public class AsciiArtRender
implements BitMatrixRender {
    private final QrConfig config;

    public AsciiArtRender(QrConfig config) {
        this.config = config;
    }

    @Override
    public void render(BitMatrix matrix, OutputStream out) {
        this.render(matrix, new OutputStreamWriter(out, this.config.getCharset()));
    }

    public void render(BitMatrix matrix, Appendable writer) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        Integer foreColor = this.config.getForeColor();
        AnsiElement foreground = foreColor == null ? null : ColorKit.toAnsiColor((int)foreColor, (boolean)true, (boolean)false);
        Integer backColor = this.config.getBackColor();
        AnsiElement background = backColor == null ? null : ColorKit.toAnsiColor((int)backColor, (boolean)true, (boolean)true);
        try {
            for (int i = 0; i <= height; i += 2) {
                StringBuilder rowBuilder = new StringBuilder();
                for (int j = 0; j < width; ++j) {
                    boolean bt;
                    boolean tp = matrix.get(i, j);
                    boolean bl = bt = i + 1 >= height || matrix.get(i + 1, j);
                    if (tp && bt) {
                        rowBuilder.append(' ');
                        continue;
                    }
                    if (tp) {
                        rowBuilder.append('\u2584');
                        continue;
                    }
                    if (bt) {
                        rowBuilder.append('\u2580');
                        continue;
                    }
                    rowBuilder.append('\u2588');
                }
                writer.append(AnsiEncoder.encode((Object[])new Object[]{foreground, background, rowBuilder})).append('\n');
            }
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

