/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.qrcode.render;

import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ColorKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.image.ImageKit;
import org.miaixz.bus.extra.qrcode.QrConfig;
import org.miaixz.bus.extra.qrcode.render.BitMatrixRender;

public class SVGRender
implements BitMatrixRender {
    private final QrConfig qrConfig;

    public SVGRender(QrConfig qrConfig) {
        this.qrConfig = qrConfig;
    }

    @Override
    public void render(BitMatrix matrix, OutputStream out) {
        this.render(matrix, new OutputStreamWriter(out, this.qrConfig.getCharset()));
    }

    public void render(BitMatrix matrix, Appendable writer) {
        Image logoImg = this.qrConfig.getImg();
        Integer foreColor = this.qrConfig.getForeColor();
        Integer backColor = this.qrConfig.getBackColor();
        int ratio = this.qrConfig.getRatio();
        int qrWidth = matrix.getWidth();
        int qrHeight = matrix.getHeight();
        int moduleHeight = qrHeight == 1 ? qrWidth / 2 : 1;
        qrHeight *= moduleHeight;
        String logoBase64 = "";
        int logoWidth = 0;
        int logoHeight = 0;
        int logoX = 0;
        int logoY = 0;
        if (logoImg != null) {
            logoBase64 = ImageKit.toBase64DataUri(logoImg, "png");
            if (qrWidth < qrHeight) {
                logoWidth = qrWidth / ratio;
                logoHeight = logoImg.getHeight(null) * logoWidth / logoImg.getWidth(null);
            } else {
                logoHeight = qrHeight / ratio;
                logoWidth = logoImg.getWidth(null) * logoHeight / logoImg.getHeight(null);
            }
            logoX = (qrWidth - logoWidth) / 2;
            logoY = (qrHeight - logoHeight) / 2;
        }
        try {
            writer.append("<svg width=\"").append(String.valueOf(qrWidth)).append("\" height=\"").append(String.valueOf(qrHeight)).append("\" \n");
            if (backColor != null) {
                Color back = new Color(backColor, true);
                writer.append("style=\"background-color:").append(ColorKit.toCssRgba((Color)back)).append("\"\n");
            }
            writer.append("viewBox=\"0 0 ").append(String.valueOf(qrWidth)).append(" ").append(String.valueOf(qrHeight)).append("\" \n");
            writer.append("xmlns=\"http://www.w3.org/2000/svg\" \n");
            writer.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" >\n");
            writer.append("<path d=\"");
            for (int y = 0; y < qrHeight; ++y) {
                for (int x = 0; x < qrWidth; ++x) {
                    if (!matrix.get(x, y)) continue;
                    writer.append(" M").append(String.valueOf(x)).append(",").append(String.valueOf(y)).append("h1v").append(String.valueOf(moduleHeight)).append("h-1z");
                }
            }
            writer.append("\" ");
            if (foreColor != null) {
                Color fore = new Color(foreColor, true);
                writer.append("stroke=\"").append(ColorKit.toCssRgba((Color)fore)).append("\"");
            }
            writer.append(" /> \n");
            if (StringKit.isNotBlank((CharSequence)logoBase64)) {
                writer.append("<image xlink:href=\"").append(logoBase64).append("\" height=\"").append(String.valueOf(logoHeight)).append("\" width=\"").append(String.valueOf(logoWidth)).append("\" y=\"").append(String.valueOf(logoY)).append("\" x=\"").append(String.valueOf(logoX)).append("\" />\n");
            }
            writer.append("</svg>");
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

