/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh.provider.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.function.Predicate;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.ftp.AbstractFtp;
import org.miaixz.bus.extra.ftp.FtpConfig;
import org.miaixz.bus.extra.ssh.Connector;
import org.miaixz.bus.extra.ssh.JschKit;
import org.miaixz.bus.extra.ssh.provider.jsch.ChannelType;
import org.miaixz.bus.extra.ssh.provider.jsch.JschSession;

public class JschSftp
extends AbstractFtp {
    private Session session;
    private ChannelSftp channel;

    public JschSftp(FtpConfig config) {
        this(config, true);
    }

    public JschSftp(FtpConfig config, boolean init) {
        super(config);
        if (init) {
            this.init();
        }
    }

    public JschSftp(Session session, Charset charset, long timeOut) {
        super(FtpConfig.of().setCharset(charset).setConnectionTimeout(timeOut));
        this.session = session;
        this.init();
    }

    public JschSftp(ChannelSftp channel, Charset charset, long timeOut) {
        super(FtpConfig.of().setCharset(charset).setConnectionTimeout(timeOut));
        this.channel = channel;
        this.init();
    }

    public static JschSftp of(String sshHost, int sshPort, String sshUser, String sshPass) {
        return JschSftp.of(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public static JschSftp of(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        return new JschSftp(new FtpConfig(Connector.of(sshHost, sshPort, sshUser, sshPass), charset));
    }

    public void init() {
        if (null == this.channel) {
            if (null == this.session) {
                FtpConfig config = this.ftpConfig;
                Connector connector = config.getConnector();
                this.session = new JschSession(Connector.of(connector.getHost(), connector.getPort(), connector.getUser(), connector.getPassword(), connector.getTimeout())).getRaw();
            }
            if (!this.session.isConnected()) {
                try {
                    this.session.connect((int)this.ftpConfig.getConnector().getTimeout());
                }
                catch (JSchException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            try {
                this.channel = (ChannelSftp)this.session.openChannel(ChannelType.SFTP.getValue());
            }
            catch (JSchException e) {
                throw new InternalException((Throwable)e);
            }
        }
        try {
            if (!this.channel.isConnected()) {
                this.channel.connect((int)Math.max(this.ftpConfig.getConnector().getTimeout(), 0L));
            }
            this.channel.setFilenameEncoding(this.ftpConfig.getCharset().toString());
        }
        catch (JSchException | SftpException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public JschSftp reconnectIfTimeout() {
        if (StringKit.isBlank((CharSequence)this.ftpConfig.getConnector().getHost())) {
            throw new InternalException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (InternalException e) {
            this.close();
            this.init();
        }
        return this;
    }

    public ChannelSftp getClient() {
        if (!this.channel.isConnected()) {
            this.init();
        }
        return this.channel;
    }

    @Override
    public String pwd() {
        try {
            return this.getClient().pwd();
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public String home() {
        try {
            return this.getClient().getHome();
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public List<String> ls(String path) {
        return this.ls(path, null);
    }

    public List<String> lsDirs(String path) {
        return this.ls(path, t -> t.getAttrs().isDir());
    }

    public List<String> lsFiles(String path) {
        return this.ls(path, t -> !t.getAttrs().isDir());
    }

    public List<String> ls(String path, Predicate<ChannelSftp.LsEntry> predicate) {
        List<ChannelSftp.LsEntry> entries = this.lsEntries(path, predicate);
        if (CollKit.isEmpty(entries)) {
            return ListKit.empty();
        }
        return CollKit.map(entries, ChannelSftp.LsEntry::getFilename);
    }

    public List<ChannelSftp.LsEntry> lsEntries(String path) {
        return this.lsEntries(path, null);
    }

    public List<ChannelSftp.LsEntry> lsEntries(String path, Predicate<ChannelSftp.LsEntry> predicate) {
        ArrayList<ChannelSftp.LsEntry> entryList;
        block2: {
            entryList = new ArrayList<ChannelSftp.LsEntry>();
            try {
                this.getClient().ls(path, entry -> {
                    String fileName = entry.getFilename();
                    if (!(StringKit.equals((CharSequence)".", (CharSequence)fileName) || StringKit.equals((CharSequence)"..", (CharSequence)fileName) || null != predicate && !predicate.test(entry))) {
                        entryList.add(entry);
                    }
                    return 0;
                });
            }
            catch (SftpException e) {
                if (StringKit.startWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"No such file")) break block2;
                throw new InternalException((Throwable)e);
            }
        }
        return entryList;
    }

    @Override
    public boolean rename(String oldPath, String newPath) {
        try {
            this.getClient().rename(oldPath, newPath);
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        return true;
    }

    @Override
    public boolean mkdir(String dir) {
        if (this.isDir(dir)) {
            return true;
        }
        try {
            this.getClient().mkdir(dir);
            return true;
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean isDir(String dir) {
        SftpATTRS sftpATTRS;
        try {
            sftpATTRS = this.getClient().stat(dir);
        }
        catch (SftpException e) {
            String msg = e.getMessage();
            if (StringKit.containsAnyIgnoreCase((CharSequence)msg, (CharSequence[])new CharSequence[]{"No such file", "does not exist"})) {
                return false;
            }
            throw new InternalException((Throwable)e);
        }
        return sftpATTRS.isDir();
    }

    @Override
    public synchronized boolean cd(String directory) throws InternalException {
        if (StringKit.isBlank((CharSequence)directory)) {
            return true;
        }
        try {
            this.getClient().cd(directory.replace('\\', '/'));
            return true;
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean delFile(String filePath) {
        try {
            this.getClient().rm(filePath);
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        return true;
    }

    @Override
    public boolean delDir(String dirPath) {
        Vector list;
        if (!this.cd(dirPath)) {
            return false;
        }
        ChannelSftp channel = this.getClient();
        try {
            list = channel.ls(channel.pwd());
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (".".equals(fileName) || "..".equals(fileName)) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.cd("..")) {
            return false;
        }
        try {
            channel.rmdir(dirPath);
            return true;
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void upload(String remotePath, File file) {
        if (!FileKit.exists((File)file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File fileItem : files) {
                if (fileItem.isDirectory()) {
                    String mkdir = FileKit.normalize((String)(remotePath + "/" + fileItem.getName()));
                    this.upload(mkdir, fileItem);
                    continue;
                }
                this.uploadFile(remotePath, fileItem);
            }
        } else {
            this.uploadFile(remotePath, file);
        }
    }

    @Override
    public boolean uploadFile(String destPath, File file) {
        if (!FileKit.isFile((File)file)) {
            throw new InternalException("[{}] is not a file!", new Object[]{file});
        }
        this.mkDirs(destPath);
        this.put(FileKit.getAbsolutePath((File)file), destPath);
        return true;
    }

    public void uploadFile(String destPath, String fileName, InputStream fileStream) {
        destPath = StringKit.addSuffixIfNot((CharSequence)destPath, (CharSequence)"/") + StringKit.removePrefix((CharSequence)fileName, (CharSequence)"/");
        this.put(fileStream, (String)destPath, null, Mode.OVERWRITE);
    }

    public JschSftp put(String srcFilePath, String destPath) {
        return this.put(srcFilePath, destPath, Mode.OVERWRITE);
    }

    public JschSftp put(String srcFilePath, String destPath, Mode mode) {
        return this.put(srcFilePath, destPath, null, mode);
    }

    public JschSftp put(String srcFilePath, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            this.getClient().put(srcFilePath, destPath, monitor, mode.ordinal());
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public JschSftp put(InputStream srcStream, String destPath, SftpProgressMonitor monitor, Mode mode) {
        try {
            this.getClient().put(srcStream, destPath, monitor, mode.ordinal());
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public void download(String src, File destFile) {
        this.get(src, FileKit.getAbsolutePath((File)destFile));
    }

    public void download(String src, OutputStream out) {
        this.get(src, out);
    }

    @Override
    public void recursiveDownloadFolder(String sourceDir, File targetDir) throws InternalException {
        List<ChannelSftp.LsEntry> entries = this.lsEntries(sourceDir = sourceDir.replaceAll("/+$", ""));
        if (entries == null || entries.isEmpty()) {
            return;
        }
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new InternalException("Failed to create target directory: " + targetDir.getAbsolutePath());
        }
        for (ChannelSftp.LsEntry item : entries) {
            String fileName = item.getFilename();
            if (fileName.equals(".") || fileName.equals("..")) continue;
            String srcPath = sourceDir + "/" + fileName;
            File destFile = new File(targetDir, fileName);
            if (item.getAttrs().isDir()) {
                this.recursiveDownloadFolder(srcPath, destFile);
                continue;
            }
            if (destFile.exists() && (long)(item.getAttrs().getMTime() * 1000) <= destFile.lastModified()) continue;
            this.download(srcPath, destFile);
        }
    }

    public JschSftp get(String src, String dest) {
        try {
            this.getClient().get(src, dest);
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public JschSftp get(String src, OutputStream out) {
        try {
            this.getClient().get(src, out);
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public InputStream getFileStream(String path) {
        try {
            return this.getClient().get(path);
        }
        catch (SftpException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void close() {
        JschKit.close((Channel)this.channel);
        this.channel = null;
        JschKit.close(this.session);
        this.session = null;
    }

    public String toString() {
        Connector connector = this.ftpConfig.getConnector();
        return "JschSftp{host='" + connector.getHost() + "', port=" + connector.getPort() + ", user='" + connector.getUser() + "'}";
    }

    public static enum Mode {
        OVERWRITE,
        RESUME,
        APPEND;

    }
}

