/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.ssh.provider.sshj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.ftp.AbstractFtp;
import org.miaixz.bus.extra.ftp.FtpConfig;
import org.miaixz.bus.extra.ssh.Connector;
import org.miaixz.bus.extra.ssh.SshjKit;

public class SshjSftp
extends AbstractFtp {
    private SSHClient ssh;
    private SFTPClient sftp;
    private Session session;
    private String workingDir;

    public SshjSftp(FtpConfig config) {
        super(config);
        this.init();
    }

    public SshjSftp(SSHClient sshClient, Charset charset) {
        super(FtpConfig.of().setCharset(charset));
        this.ssh = sshClient;
        this.init();
    }

    public static SshjSftp of(String sshHost, String sshUser, String sshPass) {
        return SshjSftp.of(sshHost, 22, sshUser, sshPass);
    }

    public static SshjSftp of(String sshHost, int sshPort, String sshUser, String sshPass) {
        return SshjSftp.of(sshHost, sshPort, sshUser, sshPass, DEFAULT_CHARSET);
    }

    public static SshjSftp of(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        return new SshjSftp(new FtpConfig(Connector.of(sshHost, sshPort, sshUser, sshPass), charset));
    }

    public void init() {
        if (null == this.ssh) {
            this.ssh = SshjKit.openClient(this.ftpConfig.getConnector());
        }
        try {
            this.ssh.setRemoteCharset(this.ftpConfig.getCharset());
            this.sftp = this.ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new InternalException("sftp \u521d\u59cb\u5316\u5931\u8d25.", (Throwable)e);
        }
    }

    @Override
    public AbstractFtp reconnectIfTimeout() {
        if (StringKit.isBlank((CharSequence)this.ftpConfig.getConnector().getHost())) {
            throw new InternalException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (InternalException e) {
            this.close();
            this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        String newPath = this.getPath(directory);
        try {
            this.sftp.ls(newPath);
            this.workingDir = newPath;
            return true;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public String pwd() {
        return this.getPath(null);
    }

    @Override
    public boolean rename(String oldPath, String newPath) {
        try {
            this.sftp.rename(oldPath, newPath);
            return this.containsFile(newPath);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.sftp.mkdir(this.getPath(dir));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this.containsFile(this.getPath(dir));
    }

    @Override
    public List<String> ls(String path) {
        List infoList;
        try {
            infoList = this.sftp.ls(this.getPath(path));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        if (CollKit.isNotEmpty((Collection)infoList)) {
            return CollKit.map((Iterable)infoList, RemoteResourceInfo::getName);
        }
        return null;
    }

    @Override
    public boolean delFile(String path) {
        try {
            this.sftp.rm(this.getPath(path));
            return !this.containsFile(this.getPath(path));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean delDir(String dirPath) {
        try {
            this.sftp.rmdir(this.getPath(dirPath));
            return !this.containsFile(this.getPath(dirPath));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public boolean uploadFile(String destPath, File file) {
        try {
            if (StringKit.endWith((CharSequence)destPath, (CharSequence)"/")) {
                destPath = (String)destPath + file.getName();
            }
            this.sftp.put((LocalSourceFile)new FileSystemFile(file), this.getPath((String)destPath));
            return this.containsFile(this.getPath((String)destPath));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void download(String path, File outFile) {
        try {
            this.sftp.get(this.getPath(path), (LocalDestFile)new FileSystemFile(outFile));
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void recursiveDownloadFolder(String sourceDir, File targetDir) {
        if (!(targetDir.exists() && targetDir.isDirectory() || targetDir.mkdirs())) {
            throw new InternalException("\u521b\u5efa\u76ee\u5f55" + targetDir.getAbsolutePath() + "\u5931\u8d25");
        }
        List<String> files = this.ls(this.getPath(sourceDir));
        if (files != null && !files.isEmpty()) {
            files.forEach(file -> this.download(sourceDir + "/" + file, FileKit.file((File)targetDir, (String)file)));
        }
    }

    @Override
    public InputStream getFileStream(String path) {
        RemoteFile remoteFile;
        try {
            remoteFile = this.sftp.open(path);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        RemoteFile remoteFile2 = remoteFile;
        Objects.requireNonNull(remoteFile2);
        return new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile2, 16);
    }

    @Override
    public void close() {
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.session});
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.sftp});
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.ssh});
    }

    public boolean containsFile(String fileDir) {
        try {
            this.sftp.lstat(this.getPath(fileDir));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String command(String exec) {
        String string;
        Session session = this.initSession();
        Session.Command command = null;
        try {
            command = session.exec(exec);
            InputStream inputStream = command.getInputStream();
            string = IoKit.read((InputStream)inputStream, (Charset)this.ftpConfig.getCharset());
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{command});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{command});
        return string;
    }

    private Session initSession() {
        Session session = this.session;
        if (null == session || !session.isOpen()) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{session});
            try {
                session = this.ssh.startSession();
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
            this.session = session;
        }
        return session;
    }

    private String getPath(String path) {
        if (StringKit.isBlank((CharSequence)this.workingDir)) {
            try {
                this.workingDir = this.sftp.canonicalize("");
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        if (StringKit.isBlank((CharSequence)path)) {
            return this.workingDir;
        }
        if (StringKit.startWith((CharSequence)path, (CharSequence)"/")) {
            return path;
        }
        String tmp = StringKit.removeSuffix((CharSequence)this.workingDir, (CharSequence)"/");
        return StringKit.format((CharSequence)"{}/{}", (Object[])new Object[]{tmp, path});
    }
}

