/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.template;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import org.miaixz.bus.extra.template.TemplateProvider;

public class TemplateConfig
implements Serializable {
    private static final long serialVersionUID = 2852288273095L;
    public static final TemplateConfig DEFAULT = new TemplateConfig();
    private Charset charset;
    private String path;
    private ResourceMode resourceMode;
    private Class<? extends TemplateProvider> provider;
    private boolean useCache = true;

    public TemplateConfig() {
        this(null);
    }

    public TemplateConfig(String path) {
        this(path, ResourceMode.STRING);
    }

    public TemplateConfig(String path, ResourceMode resourceMode) {
        this(org.miaixz.bus.core.lang.Charset.UTF_8, path, resourceMode);
    }

    public TemplateConfig(Charset charset, String path, ResourceMode resourceMode) {
        this.charset = charset;
        this.path = path;
        this.resourceMode = resourceMode;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getCharsetString() {
        if (null == this.charset) {
            return null;
        }
        return this.charset.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ResourceMode getResourceMode() {
        return this.resourceMode;
    }

    public void setResourceMode(ResourceMode resourceMode) {
        this.resourceMode = resourceMode;
    }

    public Class<? extends TemplateProvider> getProvider() {
        return this.provider;
    }

    public TemplateConfig setProvider(Class<? extends TemplateProvider> provider) {
        this.provider = provider;
        return this;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public TemplateConfig setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateConfig that = (TemplateConfig)o;
        return Objects.equals(this.charset, that.charset) && Objects.equals(this.path, that.path) && this.resourceMode == that.resourceMode && Objects.equals(this.provider, that.provider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.charset, this.path, this.resourceMode, this.provider});
    }

    public static enum ResourceMode {
        CLASSPATH,
        FILE,
        WEB_ROOT,
        STRING,
        COMPOSITE;

    }
}

