/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.aoju.bus.gitlab.AbstractApi;
import org.aoju.bus.gitlab.GitLabApi;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.Pager;
import org.aoju.bus.gitlab.models.AuditEvent;
import org.aoju.bus.gitlab.support.ISO8601;

public class AuditEventApi
extends AbstractApi {
    public AuditEventApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Long entityId) throws GitLabApiException {
        return this.getAuditEvents(created_after, created_before, entityType, entityId, this.getDefaultPerPage()).all();
    }

    public Pager<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Long entityId, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("created_before", ISO8601.toString(created_before, false)).withParam("created_after", ISO8601.toString(created_after, false)).withParam("entity_type", entityType).withParam("entity_id", entityId);
        return new Pager<AuditEvent>(this, AuditEvent.class, itemsPerPage, (MultivaluedMap<String, String>)form.asMap(), "audit_events");
    }

    public Stream<AuditEvent> getAuditEventsStream(Date created_after, Date created_before, String entityType, Long entityId) throws GitLabApiException {
        return this.getAuditEvents(created_after, created_before, entityType, entityId, this.getDefaultPerPage()).stream();
    }

    public AuditEvent getAuditEvent(Long auditEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "audit_events", auditEventId);
        return (AuditEvent)response.readEntity(AuditEvent.class);
    }
}

