/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.aoju.bus.gitlab.AbstractApi;
import org.aoju.bus.gitlab.GitLabApi;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.Pager;
import org.aoju.bus.gitlab.models.DeployKey;

public class DeployKeysApi
extends AbstractApi {
    public DeployKeysApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<DeployKey> getDeployKeys() throws GitLabApiException {
        return this.getDeployKeys(this.getDefaultPerPage()).all();
    }

    public List<DeployKey> getDeployKeys(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "deploy_keys");
        return (List)response.readEntity((GenericType)new GenericType<List<DeployKey>>(){});
    }

    public Pager<DeployKey> getDeployKeys(int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployKey>(this, DeployKey.class, itemsPerPage, null, "deploy_keys");
    }

    public Stream<DeployKey> getDeployKeysStream() throws GitLabApiException {
        return this.getDeployKeys(this.getDefaultPerPage()).stream();
    }

    public List<DeployKey> getProjectDeployKeys(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployKeys(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<DeployKey> getProjectDeployKeys(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys");
        return (List)response.readEntity((GenericType)new GenericType<List<DeployKey>>(){});
    }

    public Pager<DeployKey> getProjectDeployKeys(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployKey>(this, DeployKey.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys");
    }

    public Stream<DeployKey> getProjectDeployKeysStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployKeys(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public DeployKey getDeployKey(Object projectIdOrPath, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", keyId);
        return (DeployKey)response.readEntity(DeployKey.class);
    }

    public Optional<DeployKey> getOptionalDeployKey(Object projectIdOrPath, Long keyId) {
        try {
            return Optional.ofNullable(this.getDeployKey(projectIdOrPath, keyId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public DeployKey addDeployKey(Object projectIdOrPath, String title, String key, Boolean canPush) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("key", key, true).withParam("can_push", canPush);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys"});
        return (DeployKey)response.readEntity(DeployKey.class);
    }

    public DeployKey updateDeployKey(Object projectIdOrPath, Long deployKeyId, String title, Boolean canPush) throws GitLabApiException {
        if (deployKeyId == null) {
            throw new RuntimeException("deployKeyId cannot be null");
        }
        DeployKey key = new DeployKey();
        key.setCanPush(canPush);
        key.setTitle(title);
        Response response = this.put(Response.Status.OK, key, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", deployKeyId);
        return (DeployKey)response.readEntity(DeployKey.class);
    }

    public void deleteDeployKey(Object projectIdOrPath, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", keyId);
    }

    public DeployKey enableDeployKey(Object projectIdOrPath, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", keyId, "enable"});
        return (DeployKey)response.readEntity(DeployKey.class);
    }
}

