/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.aoju.bus.gitlab.AbstractApi;
import org.aoju.bus.gitlab.GitLabApi;
import org.aoju.bus.gitlab.GitLabApiException;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.Pager;
import org.aoju.bus.gitlab.models.License;

public class LicenseApi
extends AbstractApi {
    public LicenseApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public License getLicense() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "license");
        return (License)response.readEntity(License.class);
    }

    public Optional<License> getOptionalLicense() {
        try {
            return Optional.ofNullable(this.getLicense());
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<License> getAllLicenses() throws GitLabApiException {
        return this.getAllLicenses(this.getDefaultPerPage()).all();
    }

    public Stream<License> getAllLicensesStream() throws GitLabApiException {
        return this.getAllLicenses(this.getDefaultPerPage()).stream();
    }

    public Pager<License> getAllLicenses(int itemsPerPage) throws GitLabApiException {
        return new Pager<License>(this, License.class, itemsPerPage, null, "licenses");
    }

    public License addLicense(String licenseString) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("license", licenseString, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"license"});
        return (License)response.readEntity(License.class);
    }

    public License deleteLicense(Long licenseId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "license", licenseId);
        return (License)response.readEntity(License.class);
    }
}

