/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final String[] TIME_UNITS = new String[]{"mo", "w", "d", "h", "m", "s"};
    private static final int[] TIME_UNIT_MULTIPLIERS = new int[]{576000, 144000, 28800, 3600, 60, 1};
    private static Pattern durationPattern = Pattern.compile("(\\s*(\\d+)(mo|[wdhms]))");
    private int seconds;
    private String durationString;

    public Duration(String durationString) {
        this.seconds = Duration.parse(durationString);
        this.durationString = this.seconds == 0 ? "0m" : Duration.toString(this.seconds);
    }

    public Duration(int seconds) {
        this.seconds = seconds;
        this.durationString = seconds == 0 ? "0m" : Duration.toString(seconds);
    }

    @JsonCreator
    public static Duration forValue(String value) {
        return new Duration(value);
    }

    public static final String toString(int durationSeconds) {
        return Duration.toString(durationSeconds, true);
    }

    public static final String toString(int durationSeconds, boolean includeMonths) {
        int seconds = durationSeconds;
        int months = includeMonths ? seconds / TIME_UNIT_MULTIPLIERS[0] : 0;
        int weeks = (seconds -= months * TIME_UNIT_MULTIPLIERS[0]) / TIME_UNIT_MULTIPLIERS[1];
        int days = (seconds -= weeks * TIME_UNIT_MULTIPLIERS[1]) / TIME_UNIT_MULTIPLIERS[2];
        int hours = (seconds -= days * TIME_UNIT_MULTIPLIERS[2]) / 3600;
        int minutes = (seconds -= hours * 3600) / 60;
        seconds -= minutes * 60;
        StringBuilder buf = new StringBuilder();
        if (months > 0) {
            buf.append(months).append("mo");
            if (weeks > 0) {
                buf.append(weeks).append('w');
            }
            if (seconds > 0) {
                buf.append(days).append('d').append(hours).append('h').append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(days).append('d').append(hours).append('h').append(minutes).append('m');
            } else if (hours > 0) {
                buf.append(days).append('d').append(hours).append('h');
            } else if (days > 0) {
                buf.append(days).append('d');
            }
        } else if (weeks > 0) {
            buf.append(weeks).append('w');
            if (seconds > 0) {
                buf.append(days).append('d').append(hours).append('h').append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(days).append('d').append(hours).append('h').append(minutes).append('m');
            } else if (hours > 0) {
                buf.append(days).append('d').append(hours).append('h');
            } else if (days > 0) {
                buf.append(days).append('d');
            }
        } else if (days > 0) {
            buf.append(days).append('d');
            if (seconds > 0) {
                buf.append(hours).append('h').append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(hours).append('h').append(minutes).append('m');
            } else if (hours > 0) {
                buf.append(hours).append('h');
            }
        } else if (hours > 0) {
            buf.append(hours).append('h');
            if (seconds > 0) {
                buf.append(minutes).append('m').append(seconds).append('s');
            } else if (minutes > 0) {
                buf.append(minutes).append('m');
            }
        } else if (minutes > 0) {
            buf.append(minutes).append('m');
            if (seconds > 0) {
                buf.append(seconds).append('s');
            }
        } else {
            buf.append(' ').append(seconds).append('s');
        }
        return buf.toString();
    }

    public static final int parse(String durationString) {
        durationString = durationString.toLowerCase();
        Matcher matcher = durationPattern.matcher(durationString);
        int currentUnitIndex = -1;
        int seconds = 0;
        Boolean validDuration = null;
        while (matcher.find() && validDuration != Boolean.FALSE) {
            validDuration = true;
            int numGroups = matcher.groupCount();
            if (numGroups == 3) {
                String unit = matcher.group(3);
                int nextUnitIndex = Duration.getUnitIndex(unit);
                if (nextUnitIndex > currentUnitIndex) {
                    currentUnitIndex = nextUnitIndex;
                    try {
                        seconds = (int)((long)seconds + Long.parseLong(matcher.group(2)) * (long)TIME_UNIT_MULTIPLIERS[nextUnitIndex]);
                    }
                    catch (NumberFormatException nfe) {
                        validDuration = false;
                    }
                    continue;
                }
                validDuration = false;
                continue;
            }
            validDuration = false;
        }
        if (validDuration != Boolean.TRUE) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid duration", durationString));
        }
        return seconds;
    }

    private static final int getUnitIndex(String unit) {
        for (int i = 0; i < TIME_UNITS.length; ++i) {
            if (!unit.equals(TIME_UNITS[i])) continue;
            return i;
        }
        return -1;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    @JsonValue
    public String toString() {
        return this.durationString;
    }
}

