/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.List;
import org.aoju.bus.gitlab.Constants;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.support.ISO8601;

public class IssueFilter {
    private List<String> iids;
    private Constants.IssueState state;
    private List<String> labels;
    private String milestone;
    private Constants.IssueScope scope;
    private Long authorId;
    private Long assigneeId;
    private String myReactionEmoji;
    private Constants.IssueOrderBy orderBy;
    private Constants.SortOrder sort;
    private String search;
    private Date createdAfter;
    private Date createdBefore;
    private Date updatedAfter;
    private Date updatedBefore;

    public List<String> getIids() {
        return this.iids;
    }

    public void setIids(List<String> iids) {
        this.iids = iids;
    }

    public Constants.IssueState getState() {
        return this.state;
    }

    public void setState(Constants.IssueState state) {
        this.state = state;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public Constants.IssueScope getScope() {
        return this.scope;
    }

    public void setScope(Constants.IssueScope scope) {
        this.scope = scope;
    }

    public Long getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    public Long getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
    }

    public String getMyReactionEmoji() {
        return this.myReactionEmoji;
    }

    public void setMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
    }

    public Constants.IssueOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(Constants.IssueOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public Constants.SortOrder getSort() {
        return this.sort;
    }

    public void setSort(Constants.SortOrder sort) {
        this.sort = sort;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public IssueFilter withIids(List<String> iids) {
        this.iids = iids;
        return this;
    }

    public IssueFilter withState(Constants.IssueState state) {
        this.state = state;
        return this;
    }

    public IssueFilter withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public IssueFilter withMilestone(String milestone) {
        this.milestone = milestone;
        return this;
    }

    public IssueFilter withScope(Constants.IssueScope scope) {
        this.scope = scope;
        return this;
    }

    public IssueFilter withAuthorId(Long authorId) {
        this.authorId = authorId;
        return this;
    }

    public IssueFilter withAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    public IssueFilter withMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
        return this;
    }

    public IssueFilter withOrderBy(Constants.IssueOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public IssueFilter withSort(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public IssueFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public IssueFilter withCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public IssueFilter withCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public IssueFilter withUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    public IssueFilter withUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    @JsonIgnore
    public GitLabApiForm getQueryParams(int page, int perPage) {
        return this.getQueryParams().withParam("page", page).withParam("per_page", perPage);
    }

    @JsonIgnore
    public GitLabApiForm getQueryParams() {
        return new GitLabApiForm().withParam("iids", this.iids).withParam("state", (Object)this.state).withParam("labels", this.labels != null ? String.join((CharSequence)",", this.labels) : null).withParam("milestone", this.milestone).withParam("scope", (Object)this.scope).withParam("author_id", this.authorId).withParam("assignee_id", this.assigneeId).withParam("my_reaction_emoji", this.myReactionEmoji).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("search", this.search).withParam("created_after", ISO8601.toString(this.createdAfter, false)).withParam("created_before", ISO8601.toString(this.createdBefore, false)).withParam("updated_after", ISO8601.toString(this.updatedAfter, false)).withParam("updated_before", ISO8601.toString(this.updatedBefore, false));
    }
}

