/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.aoju.bus.gitlab.GitLabApiForm;
import org.aoju.bus.gitlab.services.NotificationService;

public class EmailOnPushService
extends NotificationService {
    public static final String RECIPIENT_PROP = "recipients";
    public static final String DISABLE_DIFFS_PROP = "disable_diffs";
    public static final String SEND_FROM_COMMITTER_EMAIL_PROP = "send_from_committer_email";

    @Override
    public GitLabApiForm servicePropertiesForm() {
        GitLabApiForm formData = new GitLabApiForm().withParam(RECIPIENT_PROP, this.getRecipients(), true).withParam(DISABLE_DIFFS_PROP, this.getDisableDiffs()).withParam(SEND_FROM_COMMITTER_EMAIL_PROP, this.getSendFromCommitterEmail()).withParam("push_events", this.getPushEvents()).withParam("tag_push_events", this.getTagPushEvents()).withParam("branches_to_be_notified", (Object)this.getBranchesToBeNotified());
        return formData;
    }

    public EmailOnPushService withPushEvents(Boolean pushEvents) {
        return this.withPushEvents(pushEvents, this);
    }

    public EmailOnPushService withTagPushEvents(Boolean pushEvents) {
        return this.withTagPushEvents(pushEvents, this);
    }

    @JsonIgnore
    public String getRecipients() {
        return this.getProperty(RECIPIENT_PROP);
    }

    public void setRecipients(String recipients) {
        this.setProperty(RECIPIENT_PROP, recipients);
    }

    public EmailOnPushService withRecipients(String recipients) {
        this.setRecipients(recipients);
        return this;
    }

    @JsonIgnore
    public Boolean getDisableDiffs() {
        return (boolean)this.getProperty(DISABLE_DIFFS_PROP, false);
    }

    public void setDisableDiffs(Boolean disableDiffs) {
        this.setProperty(DISABLE_DIFFS_PROP, disableDiffs);
    }

    public EmailOnPushService withDisableDiffs(Boolean disableDiffs) {
        this.setDisableDiffs(disableDiffs);
        return this;
    }

    @JsonIgnore
    public Boolean getSendFromCommitterEmail() {
        return (boolean)this.getProperty(SEND_FROM_COMMITTER_EMAIL_PROP, false);
    }

    public void setSendFromCommitterEmail(Boolean sendFromCommitterEmail) {
        this.setProperty(SEND_FROM_COMMITTER_EMAIL_PROP, sendFromCommitterEmail);
    }

    public EmailOnPushService withSendFromCommitterEmail(Boolean sendFromCommitterEmail) {
        this.setSendFromCommitterEmail(sendFromCommitterEmail);
        return this;
    }

    @JsonIgnore
    public NotificationService.BranchesToBeNotified getBranchesToBeNotified() {
        String branchesToBeNotified = this.getProperty("branches_to_be_notified");
        if (branchesToBeNotified == null || branchesToBeNotified.isEmpty()) {
            return null;
        }
        return NotificationService.BranchesToBeNotified.valueOf(branchesToBeNotified.toUpperCase());
    }

    public void setBranchesToBeNotified(NotificationService.BranchesToBeNotified branchesToBeNotified) {
        this.setProperty("branches_to_be_notified", branchesToBeNotified.toString());
    }

    public EmailOnPushService withBranchesToBeNotified(NotificationService.BranchesToBeNotified branchesToBeNotified) {
        this.setBranchesToBeNotified(branchesToBeNotified);
        return this;
    }
}

