/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.support;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public class JacksonJsonEnumHelper<E extends Enum<E>> {
    private Map<String, E> valuesMap = new HashMap<String, E>();
    private Map<E, String> namesMap = new HashMap<E, String>();

    public JacksonJsonEnumHelper(Class<E> enumType) {
        this(enumType, false);
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized) {
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            Object name = e.name().toLowerCase();
            if (firstLetterCapitalized) {
                name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
            }
            this.valuesMap.put((String)name, e);
            this.namesMap.put(e, (String)name);
        }
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized, boolean camelCased) {
        this(enumType, firstLetterCapitalized, camelCased, false);
    }

    public JacksonJsonEnumHelper(Class<E> enumType, boolean firstLetterCapitalized, boolean camelCased, boolean preserveUnderscores) {
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            char[] chars = e.name().toLowerCase().toCharArray();
            StringBuilder nameBuf = new StringBuilder(chars.length);
            boolean nextCharIsCapitalized = firstLetterCapitalized;
            for (char ch : chars) {
                if (ch == '_') {
                    if (preserveUnderscores) {
                        nameBuf.append(ch);
                        continue;
                    }
                    if (camelCased) {
                        nextCharIsCapitalized = true;
                        continue;
                    }
                    nameBuf.append(' ');
                    continue;
                }
                if (nextCharIsCapitalized) {
                    nextCharIsCapitalized = false;
                    nameBuf.append(Character.toUpperCase(ch));
                    continue;
                }
                nameBuf.append(ch);
            }
            String name = nameBuf.toString();
            this.valuesMap.put(name, e);
            this.namesMap.put(e, name);
        }
    }

    public void addEnum(E e, String name) {
        this.valuesMap.put(name, e);
        this.namesMap.put(e, name);
    }

    @JsonCreator
    public E forValue(String value) {
        return (E)((Enum)this.valuesMap.get(value));
    }

    public String toString(E e) {
        return this.namesMap.get(e);
    }
}

