/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.support;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.message.MessageUtils;

@Priority(value=-2147483648)
public class MaskingLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    public static final List<String> DEFAULT_MASKED_HEADER_NAMES = Collections.unmodifiableList(Arrays.asList("PRIVATE-TOKEN", "Authorization", "Proxy-Authorization"));
    protected static final String REQUEST_PREFIX = "> ";
    protected static final String RESPONSE_PREFIX = "< ";
    protected static final String SECTION_PREFIX = "- ";
    protected static final String ENTITY_STREAM_PROPERTY = MaskingLoggingFilter.class.getName() + ".entityStream";
    protected static final String LOGGING_ID_PROPERTY = MaskingLoggingFilter.class.getName() + ".id";
    protected final Logger logger;
    protected final Level level;
    protected final int maxEntitySize;
    protected final AtomicLong _id = new AtomicLong(0L);
    protected Set<String> maskedHeaderNames = new HashSet<String>();

    public MaskingLoggingFilter(Logger logger, Level level) {
        this(logger, level, 0, null);
    }

    public MaskingLoggingFilter(Logger logger, Level level, int maxEntitySize) {
        this(logger, level, maxEntitySize, null);
    }

    public MaskingLoggingFilter(Logger logger, Level level, List<String> maskedHeaderNames) {
        this(logger, level, 0, maskedHeaderNames);
    }

    public MaskingLoggingFilter(Logger logger, Level level, int maxEntitySize, List<String> maskedHeaderNames) {
        this.logger = logger;
        this.level = level;
        this.maxEntitySize = maxEntitySize;
        if (maskedHeaderNames != null) {
            maskedHeaderNames.forEach(h -> this.maskedHeaderNames.add(h.toLowerCase()));
        }
    }

    public void setMaskedHeaderNames(List<String> maskedHeaderNames) {
        this.maskedHeaderNames.clear();
        if (maskedHeaderNames != null) {
            maskedHeaderNames.forEach(h -> this.addMaskedHeaderName((String)h));
        }
    }

    public void addMaskedHeaderName(String maskedHeaderName) {
        if (maskedHeaderName != null && (maskedHeaderName = maskedHeaderName.trim()).length() > 0) {
            this.maskedHeaderNames.add(maskedHeaderName.toLowerCase());
        }
    }

    protected void log(StringBuilder sb) {
        if (this.logger != null) {
            this.logger.log(this.level, sb.toString());
        }
    }

    protected StringBuilder appendId(StringBuilder sb, long id) {
        sb.append(Long.toString(id)).append(' ');
        return sb;
    }

    protected void printRequestLine(StringBuilder sb, String note, long id, String method, URI uri) {
        this.appendId(sb, id).append(SECTION_PREFIX).append(note).append(" on thread ").append(Thread.currentThread().getName()).append('\n');
        this.appendId(sb, id).append(REQUEST_PREFIX).append(method).append(' ').append(uri.toASCIIString()).append('\n');
    }

    protected void printResponseLine(StringBuilder sb, String note, long id, int status) {
        this.appendId(sb, id).append(SECTION_PREFIX).append(note).append(" on thread ").append(Thread.currentThread().getName()).append('\n');
        this.appendId(sb, id).append(RESPONSE_PREFIX).append(Integer.toString(status)).append('\n');
    }

    protected Set<Map.Entry<String, List<String>>> getSortedHeaders(Set<Map.Entry<String, List<String>>> headers) {
        TreeSet<Map.Entry<String, List<String>>> sortedHeaders = new TreeSet<Map.Entry<String, List<String>>>((o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey()));
        sortedHeaders.addAll(headers);
        return sortedHeaders;
    }

    protected void printHeaders(StringBuilder sb, long id, String prefix, MultivaluedMap<String, String> headers) {
        this.getSortedHeaders(headers.entrySet()).forEach(h -> {
            List values = (List)h.getValue();
            String header = (String)h.getKey();
            boolean isMaskedHeader = this.maskedHeaderNames.contains(header.toLowerCase());
            if (values.size() == 1) {
                String value = isMaskedHeader ? "********" : values.get(0).toString();
                this.appendId(sb, id).append(prefix).append(header).append(": ").append(value).append('\n');
            } else {
                StringBuilder headerBuf = new StringBuilder();
                for (Object value : values) {
                    if (headerBuf.length() == 0) {
                        headerBuf.append(", ");
                    }
                    headerBuf.append(isMaskedHeader ? "********" : value.toString());
                }
                this.appendId(sb, id).append(prefix).append(header).append(": ").append(headerBuf.toString()).append('\n');
            }
        });
    }

    protected void buildEntityLogString(StringBuilder sb, byte[] entity, int entitySize, Charset charset) {
        sb.append(new String(entity, 0, Math.min(entitySize, this.maxEntitySize), charset));
        if (entitySize > this.maxEntitySize) {
            sb.append("...more...");
        }
        sb.append('\n');
    }

    private InputStream logResponseEntity(StringBuilder sb, InputStream stream, Charset charset) throws IOException {
        if (this.maxEntitySize <= 0) {
            return stream;
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(this.maxEntitySize + 1);
        byte[] entity = new byte[this.maxEntitySize + 1];
        int entitySize = stream.read(entity);
        this.buildEntityLogString(sb, entity, entitySize, charset);
        stream.reset();
        return stream;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        long id = this._id.incrementAndGet();
        requestContext.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder sb = new StringBuilder();
        this.printRequestLine(sb, "Sending client request", id, requestContext.getMethod(), requestContext.getUri());
        this.printHeaders(sb, id, REQUEST_PREFIX, (MultivaluedMap<String, String>)requestContext.getStringHeaders());
        if (requestContext.hasEntity() && this.maxEntitySize > 0) {
            LoggingStream stream = new LoggingStream(sb, requestContext.getEntityStream());
            requestContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)stream);
        } else {
            this.log(sb);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder sb = new StringBuilder();
        this.printResponseLine(sb, "Received server response", id, responseContext.getStatus());
        this.printHeaders(sb, id, RESPONSE_PREFIX, (MultivaluedMap<String, String>)responseContext.getHeaders());
        if (responseContext.hasEntity() && this.maxEntitySize > 0) {
            responseContext.setEntityStream(this.logResponseEntity(sb, responseContext.getEntityStream(), MessageUtils.getCharset((MediaType)responseContext.getMediaType())));
        }
        this.log(sb);
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        context.proceed();
        if (stream == null) {
            return;
        }
        MediaType mediaType = context.getMediaType();
        if (mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE) || mediaType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            this.log(stream.getStringBuilder(MessageUtils.getCharset((MediaType)mediaType)));
        }
    }

    protected class LoggingStream
    extends FilterOutputStream {
        private final StringBuilder sb;
        private final ByteArrayOutputStream outputStream;

        LoggingStream(StringBuilder sb, OutputStream out) {
            super(out);
            this.outputStream = new ByteArrayOutputStream();
            this.sb = sb;
        }

        StringBuilder getStringBuilder(Charset charset) {
            byte[] entity = this.outputStream.toByteArray();
            MaskingLoggingFilter.this.buildEntityLogString(this.sb, entity, entity.length, charset);
            return this.sb;
        }

        @Override
        public void write(int i) throws IOException {
            if (this.outputStream.size() <= MaskingLoggingFilter.this.maxEntitySize) {
                this.outputStream.write(i);
            }
            this.out.write(i);
        }
    }
}

