/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Application;

public class ApplicationsApi
extends AbstractApi {
    public ApplicationsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Application> getApplications() throws GitLabApiException {
        return this.getApplications(this.getDefaultPerPage()).all();
    }

    public List<Application> getApplications(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "applications");
        return (List)response.readEntity((GenericType)new GenericType<List<Application>>(this){});
    }

    public Pager<Application> getApplications(int itemsPerPage) throws GitLabApiException {
        return new Pager<Application>(this, Application.class, itemsPerPage, null, "applications");
    }

    public Stream<Application> getApplicationsStream() throws GitLabApiException {
        return this.getApplications(this.getDefaultPerPage()).stream();
    }

    public Application createApplication(String name, String redirectUri, Constants.ApplicationScope[] scopes) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new GitLabApiException("scopes cannot be null or empty");
        }
        return this.createApplication(name, redirectUri, Arrays.asList(scopes));
    }

    public Application createApplication(String name, String redirectUri, List<Constants.ApplicationScope> scopes) throws GitLabApiException {
        if (scopes == null || scopes.isEmpty()) {
            throw new GitLabApiException("scopes cannot be null or empty");
        }
        String scopesString = scopes.stream().map(Constants.ApplicationScope::toString).collect(Collectors.joining(","));
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("redirect_uri", redirectUri, true).withParam("scopes", scopesString, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"applications"});
        return (Application)response.readEntity(Application.class);
    }

    public void deleteApplication(Long applicationId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "applications", applicationId);
    }
}

