/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.models.AwardEmoji;

public class AwardEmojiApi
extends AbstractApi {
    public AwardEmojiApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<AwardEmoji> getIssueAwardEmojis(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji");
        return (List)response.readEntity((GenericType)new GenericType<List<AwardEmoji>>(this){});
    }

    public List<AwardEmoji> getMergeRequestAwardEmojis(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji");
        return (List)response.readEntity((GenericType)new GenericType<List<AwardEmoji>>(this){});
    }

    public List<AwardEmoji> getSnippetAwardEmojis(Object projectIdOrPath, Long snippetId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji");
        return (List)response.readEntity((GenericType)new GenericType<List<AwardEmoji>>(this){});
    }

    public List<AwardEmoji> getIssueNoteAwardEmojis(Object projectIdOrPath, Long issueIid, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji");
        return (List)response.readEntity((GenericType)new GenericType<List<AwardEmoji>>(this){});
    }

    public List<AwardEmoji> getNoteAwardEmojis(Object projectIdOrPath, Long issueIid, Long noteId) throws GitLabApiException {
        return this.getIssueNoteAwardEmojis(projectIdOrPath, issueIid, noteId);
    }

    public List<AwardEmoji> getMergeRequestNoteAwardEmojis(Object projectIdOrPath, Long mergeRequestIid, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId, "award_emoji");
        return (List)response.readEntity((GenericType)new GenericType<List<AwardEmoji>>(this){});
    }

    public AwardEmoji getIssueAwardEmoji(Object projectIdOrPath, Long issueIid, Long awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji", awardId);
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji getMergeRequestAwardEmoji(Object projectIdOrPath, Long mergeRequestIid, Long awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji", awardId);
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji getSnippetAwardEmoji(Object projectIdOrPath, Long snippetId, Long awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji", awardId);
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji getIssueNoteAwardEmoji(Object projectIdOrPath, Long issueIid, Long noteId, Long awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji", awardId);
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    @Deprecated
    public AwardEmoji getNoteAwardEmoji(Object projectIdOrPath, Long issueIid, Long noteId, Long awardId) throws GitLabApiException {
        return this.getIssueNoteAwardEmoji(projectIdOrPath, issueIid, noteId, awardId);
    }

    public AwardEmoji getMergeRequestNoteAwardEmoji(Object projectIdOrPath, Long mergeRequestIid, Long noteId, Long awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId, "award_emoji", awardId);
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addIssueAwardEmoji(Object projectIdOrPath, Long issueIid, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji"});
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addMergeRequestAwardEmoji(Object projectIdOrPath, Long mergeRequestIid, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji"});
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addSnippetAwardEmoji(Object projectIdOrPath, Long snippetId, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji"});
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addIssueNoteAwardEmoji(Object projectIdOrPath, Long issueIid, Long noteId, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji"});
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    @Deprecated
    public AwardEmoji addNoteAwardEmoji(Object projectIdOrPath, Long issueIid, Long noteId, String name) throws GitLabApiException {
        return this.addIssueNoteAwardEmoji(projectIdOrPath, issueIid, noteId, name);
    }

    public AwardEmoji addMergeRequestAwardEmoji(Object projectIdOrPath, Integer mergeRequestIid, Integer noteId, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId, "award_emoji"});
        return (AwardEmoji)response.readEntity(AwardEmoji.class);
    }

    public void deleteIssueAwardEmoji(Object projectIdOrPath, Long issueIid, Long awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji", awardId);
    }

    public void deleteMergeRequestAwardEmoji(Object projectIdOrPath, Long mergeRequestIid, Long awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji", awardId);
    }

    public void deleteSnippetAwardEmoji(Object projectIdOrPath, Long snippetId, Long awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji", awardId);
    }

    public void deleteIssueNoteAwardEmoji(Object projectIdOrPath, Long issueIid, Long noteId, Long awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji", awardId);
    }

    @Deprecated
    public void deleteNoteAwardEmoji(Object projectIdOrPath, Long issueIid, Long noteId, Long awardId) throws GitLabApiException {
        this.deleteIssueNoteAwardEmoji(projectIdOrPath, issueIid, noteId, awardId);
    }

    public void deleteMergeRequestNoteAwardEmoji(Object projectIdOrPath, Long mergeRequestIid, Long noteId, Long awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId, "award_emoji", awardId);
    }
}

