/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.LicenseTemplate;

public class LicenseTemplatesApi
extends AbstractApi {
    public LicenseTemplatesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<LicenseTemplate> getLicenseTemplates() throws GitLabApiException {
        return this.getLicenseTemplates(false, this.getDefaultPerPage()).all();
    }

    public Stream<LicenseTemplate> getLicenseTemplatesStream() throws GitLabApiException {
        return this.getLicenseTemplates(false, this.getDefaultPerPage()).stream();
    }

    public Pager<LicenseTemplate> getLicenseTemplates(int itemsPerPage) throws GitLabApiException {
        return this.getLicenseTemplates(false, itemsPerPage);
    }

    public List<LicenseTemplate> getPopularLicenseTemplates() throws GitLabApiException {
        return this.getLicenseTemplates(true, this.getDefaultPerPage()).all();
    }

    public Stream<LicenseTemplate> getPopularLicenseTemplatesStream() throws GitLabApiException {
        return this.getLicenseTemplates(true, this.getDefaultPerPage()).stream();
    }

    public Pager<LicenseTemplate> getLicenseTemplates(Boolean popular, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("popular", popular);
        return new Pager<LicenseTemplate>(this, LicenseTemplate.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "templates", "licenses");
    }

    public LicenseTemplate getLicenseTemplate(String key) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "licenses", key);
        return (LicenseTemplate)response.readEntity(LicenseTemplate.class);
    }

    public Optional<LicenseTemplate> getOptionalLicenseTemplate(String key) {
        try {
            return Optional.ofNullable(this.getLicenseTemplate(key));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }
}

