/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.support.JacksonJsonEnumHelper;

public interface Constants {
    public static final String TOTAL_HEADER = "X-Total";
    public static final String TOTAL_PAGES_HEADER = "X-Total-Pages";
    public static final String PER_PAGE = "X-Per-Page";
    public static final String PAGE_HEADER = "X-Page";
    public static final String NEXT_PAGE_HEADER = "X-Next-Page";
    public static final String PREV_PAGE_HEADER = "X-Prev-Page";
    public static final String PER_PAGE_PARAM = "per_page";
    public static final String PAGE_PARAM = "page";

    public static enum DefaultBranchProtectionLevel {
        NOT_PROTECTED(0),
        PARTIALLY_PROTECTED(1),
        FULLY_PROTECTED(2),
        PROTECTED_AGAINST_PUSHES(3),
        FULL_PROTECTION_AFTER_INITIAL_PUSH(4);

        @JsonValue
        private final int value;

        private DefaultBranchProtectionLevel(int value) {
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static enum SubgroupCreationLevel {
        OWNER,
        MAINTAINER;

        private static final JacksonJsonEnumHelper<SubgroupCreationLevel> enumHelper;

        @JsonCreator
        public static SubgroupCreationLevel forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SubgroupCreationLevel>(SubgroupCreationLevel.class);
        }
    }

    public static enum ProjectCreationLevel {
        NOONE,
        DEVELOPER,
        MAINTAINER;

        private static final JacksonJsonEnumHelper<ProjectCreationLevel> enumHelper;

        @JsonCreator
        public static ProjectCreationLevel forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectCreationLevel>(ProjectCreationLevel.class);
        }
    }

    public static enum EventScope {
        ALL;

        private static final JacksonJsonEnumHelper<EventScope> enumHelper;

        @JsonCreator
        public static EventScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<EventScope>(EventScope.class);
        }
    }

    public static enum AutoDevopsDeployStrategy {
        CONTINUOUS,
        MANUAL,
        TIMED_INCREMENTAL;

        private static final JacksonJsonEnumHelper<AutoDevopsDeployStrategy> enumHelper;

        @JsonCreator
        public static AutoDevopsDeployStrategy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<AutoDevopsDeployStrategy>(AutoDevopsDeployStrategy.class);
        }
    }

    public static enum BuildGitStrategy {
        FETCH,
        CLONE;

        private static final JacksonJsonEnumHelper<BuildGitStrategy> enumHelper;

        @JsonCreator
        public static BuildGitStrategy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<BuildGitStrategy>(BuildGitStrategy.class);
        }
    }

    public static enum SquashOption {
        NEVER,
        ALWAYS,
        DEFAULT_ON,
        DEFAULT_OFF;

        private static final JacksonJsonEnumHelper<SquashOption> enumHelper;

        @JsonCreator
        public static SquashOption forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SquashOption>(SquashOption.class);
        }
    }

    public static enum ProjectAccessTokenScope {
        API,
        READ_API,
        READ_REGISTRY,
        WRITE_REGISTRY,
        READ_REPOSITORY,
        WRITE_REPOSITORY,
        CREATE_RUNNER;

        private static final JacksonJsonEnumHelper<ProjectAccessTokenScope> enumHelper;

        @JsonCreator
        public static ProjectAccessTokenScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectAccessTokenScope>(ProjectAccessTokenScope.class);
        }
    }

    public static enum DeployTokenScope {
        READ_REPOSITORY,
        READ_REGISTRY;

        private static final JacksonJsonEnumHelper<DeployTokenScope> enumHelper;

        @JsonCreator
        public static DeployTokenScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeployTokenScope>(DeployTokenScope.class);
        }
    }

    public static enum DeploymentStatus {
        CREATED,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED;

        private static final JacksonJsonEnumHelper<DeploymentStatus> enumHelper;

        @JsonCreator
        public static DeploymentStatus forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentStatus>(DeploymentStatus.class);
        }
    }

    public static enum TodoType {
        ISSUE,
        MERGE_REQUEST;

        private static final JacksonJsonEnumHelper<TodoType> enumHelper;

        @JsonCreator
        public static TodoType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoType>(TodoType.class, true, true);
        }
    }

    public static enum TodoState {
        PENDING,
        DONE;

        private static final JacksonJsonEnumHelper<TodoState> enumHelper;

        @JsonCreator
        public static TodoState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoState>(TodoState.class);
        }
    }

    public static enum TodoAction {
        ASSIGNED,
        MENTIONED,
        BUILD_FAILED,
        MARKED,
        APPROVAL_REQUIRED,
        UNMERGEABLE,
        DIRECTLY_ADDRESSED;

        private static final JacksonJsonEnumHelper<TodoAction> enumHelper;

        @JsonCreator
        public static TodoAction forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoAction>(TodoAction.class);
        }
    }

    public static enum ProjectSearchScope {
        BLOBS,
        COMMITS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        NOTES,
        WIKI_BLOBS,
        USERS;

        private static final JacksonJsonEnumHelper<ProjectSearchScope> enumHelper;

        @JsonCreator
        public static ProjectSearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectSearchScope>(ProjectSearchScope.class);
        }
    }

    public static enum GroupSearchScope {
        PROJECTS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        WIKI_BLOBS,
        COMMITS,
        BLOBS,
        NOTES,
        USERS;

        private static final JacksonJsonEnumHelper<GroupSearchScope> enumHelper;

        @JsonCreator
        public static GroupSearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupSearchScope>(GroupSearchScope.class);
        }
    }

    public static enum SearchScope {
        PROJECTS,
        ISSUES,
        MERGE_REQUESTS,
        MILESTONES,
        SNIPPET_TITLES,
        SNIPPET_BLOBS,
        USERS,
        BLOBS,
        COMMITS,
        WIKI_BLOBS;

        private static final JacksonJsonEnumHelper<SearchScope> enumHelper;

        @JsonCreator
        public static SearchScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SearchScope>(SearchScope.class);
        }
    }

    public static enum ApplicationScope {
        API,
        READ_USER,
        SUDO,
        READ_REPOSITORY,
        OPENID,
        PROFILE,
        EMAIL;

        private static final JacksonJsonEnumHelper<ApplicationScope> enumHelper;

        @JsonCreator
        public static ApplicationScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ApplicationScope>(ApplicationScope.class);
        }
    }

    public static enum CommitBuildState {
        PENDING,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED,
        SKIPPED;

        private static final JacksonJsonEnumHelper<CommitBuildState> enumHelper;

        @JsonCreator
        public static CommitBuildState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<CommitBuildState>(CommitBuildState.class);
        }
    }

    public static enum ArchiveFormat {
        BZ2,
        TAR,
        TAR_BZ2,
        TAR_GZ,
        TB2,
        TBZ,
        TBZ2,
        ZIP;

        private static final Map<String, ArchiveFormat> valuesMap;
        private final String value = this.name().toLowerCase().replace('_', '.');

        public static ArchiveFormat forValue(String value) throws GitLabApiException {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            ArchiveFormat archiveFormat = valuesMap.get(value);
            if (archiveFormat != null) {
                return archiveFormat;
            }
            throw new GitLabApiException("Invalid format! Options are tar.gz, tar.bz2, tbz, tbz2, tb2, bz2, tar, and zip.");
        }

        public String toString() {
            return this.value;
        }

        static {
            valuesMap = new HashMap<String, ArchiveFormat>(8);
            for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
                valuesMap.put(archiveFormat.value, archiveFormat);
            }
        }
    }

    public static enum ImpersonationState {
        ALL,
        ACTIVE,
        INACTIVE;

        private static final JacksonJsonEnumHelper<ImpersonationState> enumHelper;

        @JsonCreator
        public static ImpersonationState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ImpersonationState>(ImpersonationState.class);
        }
    }

    public static enum LineType {
        OLD,
        NEW;

        private static final JacksonJsonEnumHelper<LineType> enumHelper;

        @JsonCreator
        public static LineType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<LineType>(LineType.class);
        }
    }

    public static enum TargetType {
        ISSUE,
        MILESTONE,
        MERGE_REQUEST,
        NOTE,
        PROJECT,
        SNIPPET,
        USER;

        private static final JacksonJsonEnumHelper<TargetType> enumHelper;

        @JsonCreator
        public static TargetType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TargetType>(TargetType.class, true, false, true);
        }
    }

    public static enum ActionType {
        CREATED,
        UPDATED,
        OPENED,
        CLOSED,
        REOPENED,
        PUSHED,
        COMMENTED,
        MERGED,
        JOINED,
        LEFT,
        DESTROYED,
        EXPIRED,
        REMOVED,
        DELETED,
        APPROVED,
        ACCEPTED,
        IMPORTED;

        private static final JacksonJsonEnumHelper<ActionType> enumHelper;

        @JsonCreator
        public static ActionType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ActionType>(ActionType.class);
        }
    }

    public static enum MilestoneState {
        ACTIVE,
        CLOSED,
        ACTIVATE,
        CLOSE;

        private static final JacksonJsonEnumHelper<MilestoneState> enumHelper;

        @JsonCreator
        public static MilestoneState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MilestoneState>(MilestoneState.class);
        }
    }

    public static enum IssueState {
        OPENED,
        CLOSED,
        REOPENED;

        private static final JacksonJsonEnumHelper<IssueState> enumHelper;

        @JsonCreator
        public static IssueState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueState>(IssueState.class);
        }
    }

    public static enum StateEvent {
        CLOSE,
        REOPEN;

        private static final JacksonJsonEnumHelper<StateEvent> enumHelper;

        @JsonCreator
        public static StateEvent forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<StateEvent>(StateEvent.class);
        }
    }

    public static enum MergeRequestSearchIn {
        TITLE,
        DESCRIPTION;

        private static final JacksonJsonEnumHelper<MergeRequestSearchIn> enumHelper;

        @JsonCreator
        public static MergeRequestSearchIn forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestSearchIn>(MergeRequestSearchIn.class);
        }
    }

    public static enum MergeRequestState {
        OPENED,
        CLOSED,
        LOCKED,
        MERGED,
        ALL;

        private static final JacksonJsonEnumHelper<MergeRequestState> enumHelper;

        @JsonCreator
        public static MergeRequestState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestState>(MergeRequestState.class);
        }
    }

    public static enum MergeRequestScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static final JacksonJsonEnumHelper<MergeRequestScope> enumHelper;

        @JsonCreator
        public static MergeRequestScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestScope>(MergeRequestScope.class);
        }
    }

    public static enum IssueScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static final JacksonJsonEnumHelper<IssueScope> enumHelper;

        @JsonCreator
        public static IssueScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueScope>(IssueScope.class);
        }
    }

    public static enum JobScope {
        CREATED,
        PENDING,
        RUNNING,
        FAILED,
        SUCCESS,
        CANCELED,
        SKIPPED,
        MANUAL;

        private static final JacksonJsonEnumHelper<JobScope> enumHelper;

        @JsonCreator
        public static JobScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<JobScope>(JobScope.class);
        }
    }

    public static enum PipelineScope {
        RUNNING,
        PENDING,
        FINISHED,
        BRANCHES,
        TAGS;

        private static final JacksonJsonEnumHelper<PipelineScope> enumHelper;

        @JsonCreator
        public static PipelineScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineScope>(PipelineScope.class);
        }
    }

    public static enum ContributorOrderBy {
        NAME,
        EMAIL,
        COMMITS;

        private static final JacksonJsonEnumHelper<ContributorOrderBy> enumHelper;

        @JsonCreator
        public static ContributorOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ContributorOrderBy>(ContributorOrderBy.class);
        }
    }

    public static enum DeploymentOrderBy {
        ID,
        IID,
        CREATED_AT,
        UPDATED_AT,
        REF;

        private static final JacksonJsonEnumHelper<DeploymentOrderBy> enumHelper;

        @JsonCreator
        public static DeploymentOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentOrderBy>(DeploymentOrderBy.class);
        }
    }

    public static enum TagOrderBy {
        NAME,
        UPDATED;

        private static final JacksonJsonEnumHelper<TagOrderBy> enumHelper;

        @JsonCreator
        public static TagOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TagOrderBy>(TagOrderBy.class);
        }
    }

    public static enum GroupOrderBy {
        NAME,
        PATH,
        ID,
        SIMILARITY;

        private static final JacksonJsonEnumHelper<GroupOrderBy> enumHelper;

        @JsonCreator
        public static GroupOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupOrderBy>(GroupOrderBy.class);
        }
    }

    public static enum MergeRequestOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static final JacksonJsonEnumHelper<MergeRequestOrderBy> enumHelper;

        @JsonCreator
        public static MergeRequestOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestOrderBy>(MergeRequestOrderBy.class);
        }
    }

    public static enum PipelineOrderBy {
        ID,
        STATUS,
        REF,
        UPDATED_AT,
        USER_ID;

        private static final JacksonJsonEnumHelper<PipelineOrderBy> enumHelper;

        @JsonCreator
        public static PipelineOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineOrderBy>(PipelineOrderBy.class);
        }
    }

    public static enum ProjectOrderBy {
        ID,
        NAME,
        PATH,
        CREATED_AT,
        UPDATED_AT,
        LAST_ACTIVITY_AT;

        private static final JacksonJsonEnumHelper<ProjectOrderBy> enumHelper;

        @JsonCreator
        public static ProjectOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectOrderBy>(ProjectOrderBy.class);
        }
    }

    public static enum PackageStatus {
        DEFAULT,
        HIDDEN,
        PROCESSING;

        private static final JacksonJsonEnumHelper<PackageStatus> enumHelper;

        @JsonCreator
        public static PackageStatus forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PackageStatus>(PackageStatus.class);
        }
    }

    public static enum PackageOrderBy {
        NAME,
        CREATED_AT,
        VERSION,
        TYPE,
        PROJECT_PATH;

        private static final JacksonJsonEnumHelper<PackageOrderBy> enumHelper;

        @JsonCreator
        public static PackageOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PackageOrderBy>(PackageOrderBy.class);
        }
    }

    public static enum IssueOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static final JacksonJsonEnumHelper<IssueOrderBy> enumHelper;

        @JsonCreator
        public static IssueOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueOrderBy>(IssueOrderBy.class);
        }
    }

    public static enum EpicOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static final JacksonJsonEnumHelper<EpicOrderBy> enumHelper;

        @JsonCreator
        public static EpicOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<EpicOrderBy>(EpicOrderBy.class);
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

        private static final JacksonJsonEnumHelper<SortOrder> enumHelper;

        @JsonCreator
        public static SortOrder forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SortOrder>(SortOrder.class);
        }
    }

    public static enum Encoding {
        TEXT,
        BASE64;

        private static final JacksonJsonEnumHelper<Encoding> enumHelper;

        @JsonCreator
        public static Encoding forValue(String value) {
            return enumHelper.forValue(value != null ? value.toLowerCase() : value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<Encoding>(Encoding.class);
        }
    }

    public static enum TokenType {
        ACCESS,
        OAUTH2_ACCESS,
        PRIVATE;

    }
}

