/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Namespace;

public class NamespaceApi
extends AbstractApi {
    public NamespaceApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Namespace> getNamespaces() throws GitLabApiException {
        return this.getNamespaces(this.getDefaultPerPage()).all();
    }

    public List<Namespace> getNamespaces(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "namespaces");
        return (List)response.readEntity((GenericType)new GenericType<List<Namespace>>(this){});
    }

    public Pager<Namespace> getNamespaces(int itemsPerPage) throws GitLabApiException {
        return new Pager<Namespace>(this, Namespace.class, itemsPerPage, null, "namespaces");
    }

    public Stream<Namespace> getNamespacesStream() throws GitLabApiException {
        return this.getNamespaces(this.getDefaultPerPage()).stream();
    }

    public List<Namespace> findNamespaces(String query) throws GitLabApiException {
        return this.findNamespaces(query, this.getDefaultPerPage()).all();
    }

    public List<Namespace> findNamespaces(String query, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", query, true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "namespaces");
        return (List)response.readEntity((GenericType)new GenericType<List<Namespace>>(this){});
    }

    public Pager<Namespace> findNamespaces(String query, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", query, true);
        return new Pager<Namespace>(this, Namespace.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "namespaces");
    }

    public Stream<Namespace> findNamespacesStream(String query) throws GitLabApiException {
        return this.findNamespaces(query, this.getDefaultPerPage()).stream();
    }

    public Namespace getNamespace(Object namespaceIdOrPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "namespaces", this.getNamespaceIdOrPath(namespaceIdOrPath));
        return (Namespace)response.readEntity(Namespace.class);
    }

    public Optional<Namespace> getOptionalNamespace(Object namespaceIdOrPath) {
        try {
            return Optional.ofNullable(this.getNamespace(namespaceIdOrPath));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }
}

