/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Note;

public class NotesApi
extends AbstractApi {
    public NotesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    @Deprecated
    public List<Note> getNotes(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid);
    }

    @Deprecated
    public List<Note> getNotes(Object projectIdOrPath, Long issueIid, int page, int perPage) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, page, perPage);
    }

    @Deprecated
    public Pager<Note> getNotes(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, itemsPerPage);
    }

    public List<Note> getIssueNotes(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public List<Note> getIssueNotes(Object projectIdOrPath, Long issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(this){});
    }

    public Pager<Note> getIssueNotes(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Note>(this, Note.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes");
    }

    public Stream<Note> getIssueNotesStream(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public Note getIssueNote(Object projectIdOrPath, Long issueIid, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createIssueNote(Object projectIdOrPath, Long issueIid, String body) throws GitLabApiException {
        return this.createIssueNote(projectIdOrPath, issueIid, body, null, null);
    }

    public Note createIssueNote(Object projectIdOrPath, Long issueIid, String body, Date createdAt) throws GitLabApiException {
        return this.createIssueNote(projectIdOrPath, issueIid, body, null, null);
    }

    public Note createIssueNote(Object projectIdOrPath, Long issueIid, String body, Date createdAt, Boolean internal) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt).withParam("internal", internal);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateIssueNote(Object projectIdOrPath, Long issueIid, Long noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId});
        return (Note)response.readEntity(Note.class);
    }

    public void deleteIssueNote(Object projectIdOrPath, Long issueIid, Long noteId) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issueIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, this.getDefaultPerPage()).all();
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, sortOrder, orderBy, this.getDefaultPerPage()).all();
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, int page, int perPage) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, page, perPage);
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sort", (Object)sortOrder).withParam("order_by", (Object)orderBy).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(this){});
    }

    public Pager<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, itemsPerPage);
    }

    public Stream<Note> getMergeRequestNotesStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, this.getDefaultPerPage()).stream();
    }

    public Pager<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sort", (Object)sortOrder).withParam("order_by", (Object)orderBy).withParam("page", 1).withParam("per_page", itemsPerPage);
        return new Pager<Note>(this, Note.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes");
    }

    public Stream<Note> getMergeRequestNotesStream(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, sortOrder, orderBy, this.getDefaultPerPage()).stream();
    }

    public Note getMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, Long noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId});
        return (Note)response.readEntity(Note.class);
    }

    public void deleteMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, Long noteId) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
    }
}

