/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.models.Setting;
import org.miaixz.bus.gitlab.support.JacksonJson;

public class ApplicationSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Date createdAt;
    private Date updatedAt;
    private Map<String, Object> settings = new HashMap<String, Object>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    @JsonIgnore
    public Object getSetting(Setting setting) {
        if (setting == null) {
            return null;
        }
        String name = setting.toString();
        return this.settings.get(name);
    }

    @JsonIgnore
    public Object getSetting(String setting) {
        if (setting == null) {
            return null;
        }
        return this.settings.get(setting);
    }

    public Object addSetting(String setting, Object value) throws GitLabApiException {
        Setting appSetting = Setting.forValue(setting);
        if (appSetting != null) {
            return this.addSetting(appSetting, value);
        }
        this.settings.put(setting, value);
        return value;
    }

    public Object addSetting(Setting setting, Object value) throws GitLabApiException {
        if (value instanceof JsonNode) {
            value = this.jsonNodeToValue((JsonNode)value);
        }
        setting.validate(value);
        this.settings.put(setting.toString(), value);
        return value;
    }

    public Object removeSetting(Setting setting) {
        return this.settings.remove(setting.toString());
    }

    public Object removeSetting(String setting) {
        return this.settings.remove(setting);
    }

    public void clearSettings() {
        this.settings.clear();
    }

    private Object jsonNodeToValue(JsonNode node) {
        String[] value = node;
        if (node instanceof NullNode) {
            value = null;
        } else if (node instanceof TextNode) {
            value = node.asText();
        } else if (node instanceof BooleanNode) {
            value = node.asBoolean();
        } else if (node instanceof IntNode) {
            value = node.asInt();
        } else if (node instanceof FloatNode) {
            value = Float.valueOf((float)((FloatNode)node).asDouble());
        } else if (node instanceof DoubleNode) {
            value = Float.valueOf((float)((DoubleNode)node).asDouble());
        } else if (node instanceof ArrayNode) {
            int numItems = node.size();
            String[] values = new String[numItems];
            for (int i = 0; i < numItems; ++i) {
                values[i] = node.path(i).asText();
            }
            value = values;
        }
        return value;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }
}

