/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Date;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.support.ISO8601;

public class DeploymentFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Constants.DeploymentOrderBy orderBy;
    private Constants.SortOrder sortOrder;
    private Date updatedAfter;
    private Date updatedBefore;
    private String environment;
    private Constants.DeploymentStatus status;

    public Constants.DeploymentOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(Constants.DeploymentOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public Constants.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Constants.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Constants.DeploymentStatus getStatus() {
        return this.status;
    }

    public void setStatus(Constants.DeploymentStatus status) {
        this.status = status;
    }

    public DeploymentFilter withOrderBy(Constants.DeploymentOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public DeploymentFilter withSortOrder(Constants.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public DeploymentFilter withUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    public DeploymentFilter withUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    public DeploymentFilter withEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public DeploymentFilter withStatus(Constants.DeploymentStatus status) {
        this.status = status;
        return this;
    }

    @JsonIgnore
    public GitLabApiForm getQueryParams(int page, int perPage) {
        return this.getQueryParams().withParam("page", page).withParam("per_page", perPage);
    }

    @JsonIgnore
    public GitLabApiForm getQueryParams() {
        return new GitLabApiForm().withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sortOrder).withParam("updated_after", ISO8601.toString(this.updatedAfter, false)).withParam("updated_before", ISO8601.toString(this.updatedBefore, false)).withParam("environment", this.environment).withParam("status", (Object)this.status);
    }
}

