/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import java.io.Serializable;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApiForm;

public class GroupParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String path;
    private String description;
    private String visibility;
    private Boolean shareWithGroupLock;
    private Boolean requireTwoFactorAuthentication;
    private Integer twoFactorGracePeriod;
    private Constants.ProjectCreationLevel projectCreationLevel;
    private Boolean autoDevopsEnabled;
    private Constants.SubgroupCreationLevel subgroupCreationLevel;
    private Boolean emailsDisabled;
    private Boolean lfsEnabled;
    private Boolean requestAccessEnabled;
    private Long parentId;
    private Integer sharedRunnersMinutesLimit;
    private Integer extraSharedRunnersMinutesLimit;
    private Constants.DefaultBranchProtectionLevel defaultBranchProtection;
    private Boolean preventSharingGroupsOutsideHierarchy;
    private Boolean preventForkingOutsideGroup;
    private Boolean membershipLock;
    private Long fileTemplateProjectId;

    public GroupParams withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    public GroupParams withMembershipLock(Boolean membershipLock) {
        this.membershipLock = membershipLock;
        return this;
    }

    public GroupParams withFileTemplateProjectId(Long fileTemplateProjectId) {
        this.fileTemplateProjectId = fileTemplateProjectId;
        return this;
    }

    public GroupParams withName(String name) {
        this.name = name;
        return this;
    }

    public GroupParams withPath(String path) {
        this.path = path;
        return this;
    }

    public GroupParams withDescription(String description) {
        this.description = description;
        return this;
    }

    public GroupParams withVisibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    public GroupParams withShareWithGroupLock(Boolean shareWithGroupLock) {
        this.shareWithGroupLock = shareWithGroupLock;
        return this;
    }

    public GroupParams withRequireTwoFactorAuthentication(Boolean requireTwoFactorAuthentication) {
        this.requireTwoFactorAuthentication = requireTwoFactorAuthentication;
        return this;
    }

    public GroupParams withTwoFactorGracePeriod(Integer twoFactorGracePeriod) {
        this.twoFactorGracePeriod = twoFactorGracePeriod;
        return this;
    }

    public GroupParams withProjectCreationLevel(Constants.ProjectCreationLevel projectCreationLevel) {
        this.projectCreationLevel = projectCreationLevel;
        return this;
    }

    public GroupParams withAutoDevopsEnabled(Boolean autoDevopsEnabled) {
        this.autoDevopsEnabled = autoDevopsEnabled;
        return this;
    }

    public GroupParams withSubgroupCreationLevel(Constants.SubgroupCreationLevel subgroupCreationLevel) {
        this.subgroupCreationLevel = subgroupCreationLevel;
        return this;
    }

    public GroupParams withEmailsDisabled(Boolean emailsDisabled) {
        this.emailsDisabled = emailsDisabled;
        return this;
    }

    public GroupParams withLfsEnabled(Boolean lfsEnabled) {
        this.lfsEnabled = lfsEnabled;
        return this;
    }

    public GroupParams withRequestAccessEnabled(Boolean requestAccessEnabled) {
        this.requestAccessEnabled = requestAccessEnabled;
        return this;
    }

    public GroupParams withSharedRunnersMinutesLimit(Integer sharedRunnersMinutesLimit) {
        this.sharedRunnersMinutesLimit = sharedRunnersMinutesLimit;
        return this;
    }

    public GroupParams withExtraSharedRunnersMinutesLimit(Integer extraSharedRunnersMinutesLimit) {
        this.extraSharedRunnersMinutesLimit = extraSharedRunnersMinutesLimit;
        return this;
    }

    public GroupParams withDefaultBranchProtection(Constants.DefaultBranchProtectionLevel defaultBranchProtection) {
        this.defaultBranchProtection = defaultBranchProtection;
        return this;
    }

    public GroupParams withPreventSharingGroupsOutsideHierarchy(Boolean preventSharingGroupsOutsideHierarchy) {
        this.preventSharingGroupsOutsideHierarchy = preventSharingGroupsOutsideHierarchy;
        return this;
    }

    public GroupParams withPreventForkingOutsideGroup(Boolean preventForkingOutsideGroup) {
        this.preventForkingOutsideGroup = preventForkingOutsideGroup;
        return this;
    }

    public GitLabApiForm getForm(boolean isCreate) {
        GitLabApiForm form = new GitLabApiForm().withParam("name", this.name, isCreate).withParam("path", this.path, isCreate).withParam("description", this.description).withParam("visibility", this.visibility).withParam("share_with_group_lock", this.shareWithGroupLock).withParam("require_two_factor_authentication", this.requireTwoFactorAuthentication).withParam("two_factor_grace_period", this.twoFactorGracePeriod).withParam("project_creation_level", (Object)this.projectCreationLevel).withParam("auto_devops_enabled", this.autoDevopsEnabled).withParam("subgroup_creation_level", (Object)this.subgroupCreationLevel).withParam("emails_disabled", this.emailsDisabled).withParam("lfs_enabled", this.lfsEnabled).withParam("request_access_enabled", this.requestAccessEnabled).withParam("shared_runners_minutes_limit", this.sharedRunnersMinutesLimit).withParam("extra_shared_runners_minutes_limit", this.extraSharedRunnersMinutesLimit).withParam("default_branch_protection", (Object)this.defaultBranchProtection).withParam("prevent_sharing_groups_outside_hierarchy", this.preventSharingGroupsOutsideHierarchy).withParam("prevent_forking_outside_group", this.preventForkingOutsideGroup);
        if (isCreate) {
            form.withParam("parent_id", this.parentId);
        } else {
            form.withParam("membership_lock", this.membershipLock).withParam("file_template_project_id", this.fileTemplateProjectId);
        }
        return form;
    }
}

