/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Branch;
import org.miaixz.bus.gitlab.models.ChangelogPayload;
import org.miaixz.bus.gitlab.models.Commit;
import org.miaixz.bus.gitlab.models.CompareResults;
import org.miaixz.bus.gitlab.models.Contributor;
import org.miaixz.bus.gitlab.models.RepositoryArchiveParams;
import org.miaixz.bus.gitlab.models.TreeItem;

public class RepositoryApi
extends AbstractApi {
    public RepositoryApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Branch> getBranches(Object projectIdOrPath) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, null, this.getDefaultPerPage()).all();
    }

    public static String getFilenameFromContentDisposition(Response response) {
        String disposition = response.getHeaderString("Content-Disposition");
        if (disposition == null || disposition.trim().length() == 0) {
            return null;
        }
        return disposition.replaceFirst("(?i)^.*filename=\"([^\"]+)\".*$", "$1");
    }

    public List<Branch> getBranches(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches");
        return (List)response.readEntity((GenericType)new GenericType<List<Branch>>(this){});
    }

    public Stream<Branch> getBranchesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, null, this.getDefaultPerPage()).stream();
    }

    public Pager<Branch> getBranches(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, null, itemsPerPage);
    }

    public Branch getBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName));
        return (Branch)response.readEntity(Branch.class);
    }

    public List<Branch> getBranches(Object projectIdOrPath, String search) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, search, this.getDefaultPerPage()).all();
    }

    public Pager<Branch> getBranches(Object projectIdOrPath, String search, int itemsPerPage) throws GitLabApiException {
        MultivaluedMap queryParams = search == null ? null : new GitLabApiForm().withParam("search", this.urlEncode(search)).asMap();
        return new Pager<Branch>(this, Branch.class, itemsPerPage, (MultivaluedMap<String, String>)queryParams, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches");
    }

    public Stream<Branch> getBranchesStream(Object projectIdOrPath, String search) throws GitLabApiException {
        return this.getBranches(projectIdOrPath, search, this.getDefaultPerPage()).stream();
    }

    public Optional<Branch> getOptionalBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getBranch(projectIdOrPath, branchName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Branch createBranch(Object projectIdOrPath, String branchName, String ref) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "branch_name" : "branch", branchName, true).withParam("ref", ref, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches"});
        return (Branch)response.readEntity(Branch.class);
    }

    public void deleteBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName));
    }

    public Branch protectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName), "protect");
        return (Branch)response.readEntity(Branch.class);
    }

    public List<TreeItem> getTree(Object projectIdOrPath) throws GitLabApiException {
        return this.getTree(projectIdOrPath, "/", "master");
    }

    public Branch unprotectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "branches", this.urlEncode(branchName), "unprotect");
        return (Branch)response.readEntity(Branch.class);
    }

    public Stream<TreeItem> getTreeStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getTreeStream(projectIdOrPath, "/", "master");
    }

    public Pager<TreeItem> getTree(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getTree(projectIdOrPath, "/", "master", false, itemsPerPage);
    }

    public List<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, false);
    }

    public Pager<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName, int itemsPerPage) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, false, itemsPerPage);
    }

    public Stream<TreeItem> getTreeStream(Object projectIdOrPath, String filePath, String refName) throws GitLabApiException {
        return this.getTreeStream(projectIdOrPath, filePath, refName, false);
    }

    public List<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName, Boolean recursive) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, recursive, this.getDefaultPerPage()).all();
    }

    public Pager<TreeItem> getTree(Object projectIdOrPath, String filePath, String refName, Boolean recursive, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("id", this.getProjectIdOrPath(projectIdOrPath), true).withParam("path", filePath, false).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "ref_name" : "ref", refName != null ? this.urlEncode(refName) : null, false).withParam("recursive", recursive, false);
        return new Pager<TreeItem>(this, TreeItem.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "tree");
    }

    public Stream<TreeItem> getTreeStream(Object projectIdOrPath, String filePath, String refName, Boolean recursive) throws GitLabApiException {
        return this.getTree(projectIdOrPath, filePath, refName, recursive, this.getDefaultPerPage()).stream();
    }

    public InputStream getRawBlobContent(Object projectIdOrPath, String sha) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "blobs", sha, "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public InputStream getRepositoryArchive(Object projectIdOrPath, RepositoryArchiveParams params) throws GitLabApiException {
        GitLabApiForm formData = params.getForm();
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*/*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public InputStream getRepositoryArchive(Object projectIdOrPath, RepositoryArchiveParams params, String format) throws GitLabApiException {
        Constants.ArchiveFormat archiveFormat = Constants.ArchiveFormat.forValue(format);
        return this.getRepositoryArchive(projectIdOrPath, params, archiveFormat);
    }

    public InputStream getRepositoryArchive(Object projectIdOrPath, RepositoryArchiveParams params, Constants.ArchiveFormat format) throws GitLabApiException {
        if (format == null) {
            format = Constants.ArchiveFormat.TAR_GZ;
        }
        GitLabApiForm formData = params.getForm();
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*/*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive." + String.valueOf((Object)format));
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File getRepositoryArchive(Object projectIdOrPath, RepositoryArchiveParams params, File directory) throws GitLabApiException {
        GitLabApiForm formData = params.getForm();
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*/*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = RepositoryApi.getFilenameFromContentDisposition(response);
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public File getRepositoryArchive(Object projectIdOrPath, RepositoryArchiveParams params, File directory, String format) throws GitLabApiException {
        Constants.ArchiveFormat archiveFormat = Constants.ArchiveFormat.forValue(format);
        return this.getRepositoryArchive(projectIdOrPath, params, directory, archiveFormat);
    }

    public File getRepositoryArchive(Object projectIdOrPath, RepositoryArchiveParams params, File directory, Constants.ArchiveFormat format) throws GitLabApiException {
        if (format == null) {
            format = Constants.ArchiveFormat.TAR_GZ;
        }
        GitLabApiForm formData = params.getForm();
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*/*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "archive." + format.toString());
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = RepositoryApi.getFilenameFromContentDisposition(response);
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public CompareResults compare(Object projectIdOrPath, String from, String to, boolean straight) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("from", from, true).withParam("to", to, true).withParam("straight", straight);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "compare");
        return (CompareResults)response.readEntity(CompareResults.class);
    }

    public CompareResults compare(Object projectIdOrPath, String from, String to) throws GitLabApiException {
        return this.compare(projectIdOrPath, from, to, false);
    }

    public List<Contributor> getContributors(Object projectIdOrPath) throws GitLabApiException {
        return this.getContributors(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Contributor> getContributors(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "contributors");
        return (List)response.readEntity((GenericType)new GenericType<List<Contributor>>(this){});
    }

    public List<Contributor> getContributors(Object projectIdOrPath, int page, int perPage, Constants.ContributorOrderBy orderBy, Constants.SortOrder sortOrder) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("page", page).withParam("per_page", perPage);
        if (sortOrder != null) {
            formData.withParam("sort", (Object)sortOrder, false);
        }
        if (orderBy != null) {
            formData.withParam("order_by", (Object)orderBy, false);
        }
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "contributors");
        return (List)response.readEntity((GenericType)new GenericType<List<Contributor>>(this){});
    }

    public Pager<Contributor> getContributors(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Contributor>(this, Contributor.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "contributors");
    }

    public Stream<Contributor> getContributorsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getContributors(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Commit getMergeBase(Object projectIdOrPath, List<String> refs) throws GitLabApiException {
        if (refs == null || refs.size() < 2) {
            throw new RuntimeException("refs must conatin at least 2 refs");
        }
        ArrayList<String> encodedRefs = new ArrayList<String>(refs.size());
        for (String ref : refs) {
            encodedRefs.add(this.urlEncode(ref));
        }
        GitLabApiForm queryParams = new GitLabApiForm().withParam("refs", encodedRefs, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "merge_base");
        return (Commit)response.readEntity(Commit.class);
    }

    public Optional<Commit> getOptionalMergeBase(Object projectIdOrPath, List<String> refs) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getMergeBase(projectIdOrPath, refs));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public void deleteMergedBranches(Object projectIdOrPath) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "merged_branches");
    }

    public void generateChangelog(Object projectIdOrPath, String version) throws GitLabApiException {
        this.generateChangelog(projectIdOrPath, new ChangelogPayload(version));
    }

    public void generateChangelog(Object projectIdOrPath, ChangelogPayload payload) throws GitLabApiException {
        this.post(Response.Status.OK, (Form)payload.getFormData(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "changelog"});
    }
}

