/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.support.JacksonJson;
import org.miaixz.bus.gitlab.support.JacksonJsonEnumHelper;

public class MergeRequestFilter
implements Serializable {
    private static final long serialVersionUID = -1L;
    private Long projectId;
    private Long groupId;
    private List<Long> iids;
    private Constants.MergeRequestState state;
    private Constants.MergeRequestOrderBy orderBy;
    private Constants.SortOrder sort;
    private String milestone;
    private Boolean simpleView;
    private List<String> labels;
    private Date createdAfter;
    private Date createdBefore;
    private Date updatedAfter;
    private Date updatedBefore;
    private Constants.MergeRequestScope scope;
    private Long authorId;
    private Long assigneeId;
    private String myReactionEmoji;
    private String sourceBranch;
    private String targetBranch;
    private String search;
    private Constants.MergeRequestSearchIn in;
    private Boolean wip;
    private Map<MergeRequestField, Object> not;

    public Constants.MergeRequestState getState() {
        return this.state;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public MergeRequestFilter withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public List<Long> getIids() {
        return this.iids;
    }

    public void setIids(List<Long> iids) {
        this.iids = iids;
    }

    public MergeRequestFilter withIids(List<Long> iids) {
        this.iids = iids;
        return this;
    }

    public void setState(Constants.MergeRequestState state) {
        this.state = state;
    }

    public MergeRequestFilter withState(Constants.MergeRequestState state) {
        this.state = state;
        return this;
    }

    public Constants.MergeRequestOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(Constants.MergeRequestOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public MergeRequestFilter withOrderBy(Constants.MergeRequestOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public Constants.SortOrder getSort() {
        return this.sort;
    }

    public void setSort(Constants.SortOrder sort) {
        this.sort = sort;
    }

    public MergeRequestFilter withSort(Constants.SortOrder sort) {
        this.sort = sort;
        return this;
    }

    public Constants.MergeRequestScope getScope() {
        return this.scope;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public MergeRequestFilter withMilestone(String milestone) {
        this.milestone = milestone;
        return this;
    }

    public Boolean getSimpleView() {
        return this.simpleView;
    }

    public void setSimpleView(Boolean simpleView) {
        this.simpleView = simpleView;
    }

    public MergeRequestFilter withSimpleView(Boolean simpleView) {
        this.simpleView = simpleView;
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public MergeRequestFilter withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public MergeRequestFilter withCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public MergeRequestFilter withCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public MergeRequestFilter withUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    public Date getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public MergeRequestFilter withUpdatedBefore(Date updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    public void setScope(Constants.MergeRequestScope scope) {
        this.scope = scope;
    }

    public MergeRequestFilter withScope(Constants.MergeRequestScope scope) {
        this.scope = scope;
        return this;
    }

    public Constants.MergeRequestSearchIn getIn() {
        return this.in;
    }

    public Long getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    public MergeRequestFilter withAuthorId(Long authorId) {
        this.authorId = authorId;
        return this;
    }

    public Long getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
    }

    public MergeRequestFilter withAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    public String getMyReactionEmoji() {
        return this.myReactionEmoji;
    }

    public void setMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
    }

    public MergeRequestFilter withMyReactionEmoji(String myReactionEmoji) {
        this.myReactionEmoji = myReactionEmoji;
        return this;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public MergeRequestFilter withSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
        return this;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    public MergeRequestFilter withTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
        return this;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public MergeRequestFilter withSearch(String search) {
        this.search = search;
        return this;
    }

    public void setIn(Constants.MergeRequestSearchIn in) {
        this.in = in;
    }

    public MergeRequestFilter withIn(Constants.MergeRequestSearchIn in) {
        this.in = in;
        return this;
    }

    public Boolean getWip() {
        return this.wip;
    }

    public void setWip(Boolean wip) {
        this.wip = wip;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MergeRequestFilter withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    public MergeRequestFilter withWip(Boolean wip) {
        this.wip = wip;
        return this;
    }

    public MergeRequestFilter withNot(Map<MergeRequestField, Object> not) {
        this.not = not;
        return this;
    }

    public MergeRequestFilter withNot(MergeRequestField field, Object value) {
        if (this.not == null) {
            this.not = new LinkedHashMap<MergeRequestField, Object>();
        }
        this.not.put(field, value);
        return this;
    }

    public MergeRequestFilter withoutAuthorId(Long authorId) {
        return this.withNot(MergeRequestField.AUTHOR_ID, authorId);
    }

    public MergeRequestFilter withoutAuthorUsername(String authorUsername) {
        return this.withNot(MergeRequestField.AUTHOR_USERNAME, authorUsername);
    }

    public MergeRequestFilter withoutAssigneeId(Long assigneeId) {
        return this.withNot(MergeRequestField.ASSIGNEE_ID, assigneeId);
    }

    public MergeRequestFilter withoutAssigneeUsername(String assigneeUsername) {
        return this.withNot(MergeRequestField.ASSIGNEE_USERNAME, assigneeUsername);
    }

    public MergeRequestFilter withoutReviewerId(Long reviewerId) {
        return this.withNot(MergeRequestField.REVIEWER_ID, reviewerId);
    }

    public MergeRequestFilter withoutReviewerUsername(String reviewerUsername) {
        return this.withNot(MergeRequestField.REVIEWER_USERNAME, reviewerUsername);
    }

    public MergeRequestFilter withoutMyReactionEmoji(String myReactionEmoji) {
        return this.withNot(MergeRequestField.MY_REACTION_EMOJI, myReactionEmoji);
    }

    public MergeRequestFilter withoutMilestone(String milestone) {
        return this.withNot(MergeRequestField.MILESTONE, milestone);
    }

    public MergeRequestFilter withoutLabels(String ... labels) {
        return this.withNot(MergeRequestField.LABELS, String.join((CharSequence)",", labels));
    }

    @JsonIgnore
    public GitLabApiForm getQueryParams(int page, int perPage) {
        return this.getQueryParams().withParam("page", page).withParam("per_page", perPage);
    }

    @JsonIgnore
    public GitLabApiForm getQueryParams() {
        GitLabApiForm params = new GitLabApiForm().withParam("iids", this.iids).withParam("state", (Object)this.state).withParam("order_by", (Object)this.orderBy).withParam("sort", (Object)this.sort).withParam("milestone", this.milestone).withParam("view", this.simpleView != null && this.simpleView != false ? "simple" : null).withParam("labels", this.labels != null ? String.join((CharSequence)",", this.labels) : null).withParam("created_after", this.createdAfter).withParam("created_before", this.createdBefore).withParam("updated_after", this.updatedAfter).withParam("updated_before", this.updatedBefore).withParam("scope", (Object)this.scope).withParam("assignee_id", this.assigneeId).withParam("my_reaction_emoji", this.myReactionEmoji).withParam("source_branch", this.sourceBranch).withParam("target_branch", this.targetBranch).withParam("search", this.search).withParam("in", (Object)this.in).withParam("wip", this.wip == null ? null : (this.wip != false ? "yes" : "no")).withParam("not", this.toStringMap(this.not), false);
        if (this.authorId != null && (this.scope == Constants.MergeRequestScope.ALL || this.scope == Constants.MergeRequestScope.ASSIGNED_TO_ME)) {
            params.withParam("author_id", this.authorId);
        }
        return params;
    }

    private Map<String, Object> toStringMap(Map<MergeRequestField, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<MergeRequestField, Object> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }

    public static enum MergeRequestField {
        LABELS,
        MILESTONE,
        AUTHOR_ID,
        AUTHOR_USERNAME,
        ASSIGNEE_ID,
        ASSIGNEE_USERNAME,
        REVIEWER_ID,
        REVIEWER_USERNAME,
        MY_REACTION_EMOJI;

        private static JacksonJsonEnumHelper<MergeRequestField> enumHelper;

        @JsonCreator
        public static MergeRequestField forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestField>(MergeRequestField.class);
        }
    }
}

