/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.DeployToken;

public class DeployTokensApi
extends AbstractApi {
    public DeployTokensApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<DeployToken> getDeployTokens() throws GitLabApiException {
        return this.getDeployTokens(this.getDefaultPerPage()).all();
    }

    public Pager<DeployToken> getDeployTokens(int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployToken>(this, DeployToken.class, itemsPerPage, null, "deploy_tokens");
    }

    public Stream<DeployToken> getDeployTokensStream() throws GitLabApiException {
        return this.getDeployTokens(this.getDefaultPerPage()).stream();
    }

    public List<DeployToken> getProjectDeployTokens(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployTokens(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<DeployToken> getProjectDeployTokens(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployToken>(this, DeployToken.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_tokens");
    }

    public Stream<DeployToken> getProjectDeployTokensStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployTokens(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public DeployToken addProjectDeployToken(Object projectIdOrPath, String name, Date expiresAt, String username, List<Constants.DeployTokenScope> scopes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("expires_at", expiresAt, true).withParam("username", username, true).withParam("scopes", scopes, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_tokens"});
        return (DeployToken)response.readEntity(DeployToken.class);
    }

    public void deleteProjectDeployToken(Object projectIdOrPath, Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_tokens", tokenId);
    }

    public List<DeployToken> getGroupDeployTokens(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupDeployTokens(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<DeployToken> getGroupDeployTokens(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployToken>(this, DeployToken.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "deploy_tokens");
    }

    public Stream<DeployToken> getGroupDeployTokensStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupDeployTokens(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public DeployToken addGroupDeployToken(Object groupIdOrPath, String name, Date expiresAt, String username, List<Constants.DeployTokenScope> scopes) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("expires_at", expiresAt, true).withParam("username", username, true).withParam("scopes", scopes, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "deploy_tokens"});
        return (DeployToken)response.readEntity(DeployToken.class);
    }

    public void deleteGroupDeployToken(Object groupIdOrPath, Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "deploy_tokens", tokenId);
    }
}

