/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Environment;

public class EnvironmentsApi
extends AbstractApi {
    public EnvironmentsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Environment> getEnvironments(Object projectIdOrPath) throws GitLabApiException {
        return this.getEnvironments(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Stream<Environment> getEnvironmentsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getEnvironments(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Pager<Environment> getEnvironments(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Environment>(this, Environment.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments");
    }

    public Environment getEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
        return (Environment)response.readEntity(Environment.class);
    }

    public Optional<Environment> getOptionalEnvironment(Object projectIdOrPath, Long environmentId) {
        try {
            return Optional.ofNullable(this.getEnvironment(projectIdOrPath, environmentId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Environment createEnvironment(Object projectIdOrPath, String name, String externalUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("external_url", externalUrl);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "environments"});
        return (Environment)response.readEntity(Environment.class);
    }

    public Environment updateEnvironment(Object projectIdOrPath, Long environmentId, String name, String externalUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("external_url", externalUrl);
        Response response = this.putWithFormData(Response.Status.OK, formData, new Object[]{formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId});
        return (Environment)response.readEntity(Environment.class);
    }

    public Environment stopEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, (Form)null, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId, "stop"});
        return (Environment)response.readEntity(Environment.class);
    }

    public void deleteEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
    }

    public Environment createEnvironment(Object projectIdOrPath, Long environmentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId, "stop"});
        return (Environment)response.readEntity(Environment.class);
    }
}

