/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.gitlab.GitLabApi;

public enum AccessLevel {
    INVALID(-1),
    NONE(0),
    MINIMAL_ACCESS(5),
    GUEST(10),
    REPORTER(20),
    DEVELOPER(30),
    MASTER(40),
    MAINTAINER(40),
    OWNER(50),
    ADMIN(60);

    private static Map<Integer, AccessLevel> valuesMap;
    public final Integer value;

    private AccessLevel(int value) {
        this.value = value;
    }

    @JsonCreator
    public static AccessLevel forValue(Integer value) {
        AccessLevel level = valuesMap.get(value);
        if (level != null) {
            return level;
        }
        GitLabApi.getLogger().warning(String.format("[%d] is not a valid GitLab access level.", value));
        return value == null ? null : INVALID;
    }

    @JsonValue
    public Integer toValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    static {
        valuesMap = new HashMap<Integer, AccessLevel>(9);
        for (AccessLevel accessLevel : AccessLevel.values()) {
            valuesMap.put(accessLevel.value, accessLevel);
        }
        valuesMap.put(AccessLevel.MAINTAINER.value, MAINTAINER);
    }
}

