/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PipelineStatus {
    CREATED,
    WAITING_FOR_RESOURCE,
    PREPARING,
    PENDING,
    RUNNING,
    SUCCESS,
    FAILED,
    CANCELED,
    SKIPPED,
    MANUAL,
    SCHEDULED;

    private static Map<String, PipelineStatus> valuesMap;

    @JsonCreator
    public static PipelineStatus forValue(String value) {
        return valuesMap.get(value);
    }

    @JsonValue
    public String toValue() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        valuesMap = new HashMap<String, PipelineStatus>(11);
        for (PipelineStatus status : PipelineStatus.values()) {
            valuesMap.put(status.toValue(), status);
        }
    }
}

