/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.Constants;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Todo;

public class TodosApi
extends AbstractApi {
    public TodosApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Todo> getPendingTodos() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.PENDING, null, this.getDefaultPerPage()).all();
    }

    public Pager<Todo> getPendingTodos(int itemsPerPage) throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.PENDING, null, itemsPerPage);
    }

    public Stream<Todo> getPendingTodosStream() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.PENDING, null, this.getDefaultPerPage()).stream();
    }

    public List<Todo> getDoneTodos() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.DONE, null, this.getDefaultPerPage()).all();
    }

    public Pager<Todo> getDoneTodos(int itemsPerPage) throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.DONE, null, itemsPerPage);
    }

    public Stream<Todo> getDoneTodosStream() throws GitLabApiException {
        return this.getTodos(null, null, null, null, Constants.TodoState.DONE, null, this.getDefaultPerPage()).stream();
    }

    public List<Todo> getTodos(Constants.TodoAction action, Long authorId, Long projectId, Long groupId, Constants.TodoState state, Constants.TodoType type) throws GitLabApiException {
        return this.getTodos(action, authorId, projectId, groupId, state, type, this.getDefaultPerPage()).all();
    }

    public Stream<Todo> getTodosStream(Constants.TodoAction action, Long authorId, Long projectId, Long groupId, Constants.TodoState state, Constants.TodoType type) throws GitLabApiException {
        return this.getTodos(action, authorId, projectId, groupId, state, type, this.getDefaultPerPage()).stream();
    }

    public Pager<Todo> getTodos(Constants.TodoAction action, Long authorId, Long projectId, Long groupId, Constants.TodoState state, Constants.TodoType type, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action, false).withParam("author_id", authorId, false).withParam("project_id", projectId, false).withParam("group_id", groupId, false).withParam("state", (Object)state, false).withParam("type", (Object)type, false);
        return new Pager<Todo>(this, Todo.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "todos");
    }

    public Todo markAsDone(Long todoId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"todos", todoId, "mark_as_done"});
        return (Todo)response.readEntity(Todo.class);
    }

    public void markAllAsDone() throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        this.post(Response.Status.NO_CONTENT, (Form)formData, new Object[]{"todos", "mark_as_done"});
    }
}

