/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.models.HealthCheckInfo;

public class HealthCheckApi
extends AbstractApi {
    public HealthCheckApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public HealthCheckInfo getLiveness() throws GitLabApiException {
        return this.getLiveness(null);
    }

    public HealthCheckInfo getLiveness(String token) throws GitLabApiException {
        try {
            URL livenessUrl = this.getApiClient().getUrlWithBase("-", "liveness");
            GitLabApiForm formData = new GitLabApiForm().withParam("token", token, false);
            Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), livenessUrl);
            return (HealthCheckInfo)response.readEntity(HealthCheckInfo.class);
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public HealthCheckInfo getReadiness() throws GitLabApiException {
        return this.getReadiness(null);
    }

    public HealthCheckInfo getReadiness(String token) throws GitLabApiException {
        try {
            URL readinessUrl = this.getApiClient().getUrlWithBase("-", "readiness");
            GitLabApiForm formData = new GitLabApiForm().withParam("token", token, false);
            Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), readinessUrl);
            return (HealthCheckInfo)response.readEntity(HealthCheckInfo.class);
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }
}

