/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.AccessLevel;
import org.miaixz.bus.gitlab.models.AllowedTo;
import org.miaixz.bus.gitlab.models.GitLabForm;
import org.miaixz.bus.gitlab.models.ProtectedBranch;

public class ProtectedBranchesApi
extends AbstractApi {
    public ProtectedBranchesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<ProtectedBranch> getProtectedBranches(Object projectIdOrPath) throws GitLabApiException {
        return this.getProtectedBranches(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<ProtectedBranch> getProtectedBranches(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<ProtectedBranch>(this, ProtectedBranch.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches");
    }

    public Stream<ProtectedBranch> getProtectedBranchesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProtectedBranches(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public ProtectedBranch getProtectedBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches", this.urlEncode(branchName));
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public Optional<ProtectedBranch> getOptionalProtectedBranch(Object projectIdOrPath, String branchName) {
        try {
            return Optional.ofNullable(this.getProtectedBranch(projectIdOrPath, branchName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public void unprotectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches", this.urlEncode(branchName));
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName) throws GitLabApiException {
        return this.protectBranch(projectIdOrPath, branchName, AccessLevel.MAINTAINER, AccessLevel.MAINTAINER);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AccessLevel pushAccessLevel, AccessLevel mergeAccessLevel) throws GitLabApiException {
        return this.protectBranch(projectIdOrPath, branchName, pushAccessLevel, mergeAccessLevel, null, null, null);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AccessLevel pushAccessLevel, AccessLevel mergeAccessLevel, AccessLevel unprotectAccessLevel, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        return this.protectBranch(projectIdOrPath, branchName, pushAccessLevel, mergeAccessLevel, unprotectAccessLevel, codeOwnerApprovalRequired, null);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AccessLevel pushAccessLevel, AccessLevel mergeAccessLevel, AccessLevel unprotectAccessLevel, Boolean codeOwnerApprovalRequired, Boolean allowForcedPush) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", branchName, true).withParam("push_access_level", pushAccessLevel).withParam("merge_access_level", mergeAccessLevel).withParam("unprotect_access_level", unprotectAccessLevel).withParam("code_owner_approval_required", codeOwnerApprovalRequired).withParam("allow_force_push", allowForcedPush);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, Long allowedToPushUserId, Long allowedToMergeUserId, Long allowedToUnprotectUserId, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        return this.protectBranch(projectIdOrPath, branchName, allowedToPushUserId, allowedToMergeUserId, allowedToUnprotectUserId, codeOwnerApprovalRequired, null);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, Long allowedToPushUserId, Long allowedToMergeUserId, Long allowedToUnprotectUserId, Boolean codeOwnerApprovalRequired, Boolean allowForcedPush) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", branchName, true).withParam("allowed_to_push[][user_id]", allowedToPushUserId).withParam("allowed_to_merge[][user_id]", allowedToMergeUserId).withParam("allowed_to_unprotect[][user_id]", allowedToUnprotectUserId).withParam("code_owner_approval_required", codeOwnerApprovalRequired).withParam("allow_force_push", allowForcedPush);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public ProtectedBranch protectBranch(Object projectIdOrPath, String branchName, AllowedTo allowedToPush, AllowedTo allowedToMerge, AllowedTo allowedToUnprotect, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        GitLabForm formData = new GitLabForm().withParam("name", branchName, true).withParam("code_owner_approval_required", codeOwnerApprovalRequired);
        if (allowedToPush != null) {
            allowedToPush.getForm(formData, "allowed_to_push");
        }
        if (allowedToMerge != null) {
            allowedToMerge.getForm(formData, "allowed_to_merge");
        }
        if (allowedToUnprotect != null) {
            allowedToUnprotect.getForm(formData, "allowed_to_unprotect");
        }
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)new GitLabApiForm(formData).asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches"});
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }

    public ProtectedBranch setCodeOwnerApprovalRequired(Object projectIdOrPath, String branchName, Boolean codeOwnerApprovalRequired) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("code_owner_approval_required", codeOwnerApprovalRequired);
        Response response = this.patch(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "protected_branches", this.urlEncode(branchName));
        return (ProtectedBranch)response.readEntity(ProtectedBranch.class);
    }
}

