/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.models.Deployment;
import org.miaixz.bus.gitlab.models.DeploymentFilter;
import org.miaixz.bus.gitlab.models.MergeRequest;

public class DeploymentsApi
extends AbstractApi {
    public DeploymentsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Deployment> getProjectDeployments(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, null, this.getDefaultPerPage()).all();
    }

    public Pager<Deployment> getProjectDeployments(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, null, itemsPerPage);
    }

    public Pager<Deployment> getProjectDeployments(Object projectIdOrPath, DeploymentFilter filter) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, filter, this.getDefaultPerPage());
    }

    public Pager<Deployment> getProjectDeployments(Object projectIdOrPath, DeploymentFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter != null ? new GitLabApiForm(filter.getQueryParams()) : new GitLabApiForm();
        return new Pager<Deployment>(this, Deployment.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments");
    }

    public Stream<Deployment> getProjectDeploymentsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, null, this.getDefaultPerPage()).stream();
    }

    public Stream<Deployment> getProjectDeploymentsStream(Object projectIdOrPath, DeploymentFilter filter) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public Deployment getDeployment(Object projectIdOrPath, Long deploymentId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments", deploymentId);
        return (Deployment)response.readEntity(Deployment.class);
    }

    public Optional<Deployment> getOptionalDeployment(Object projectIdOrPath, Long deploymentId) {
        try {
            return Optional.ofNullable(this.getDeployment(projectIdOrPath, deploymentId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Deployment addDeployment(Object projectIdOrPath, String environment, String sha, String ref, Boolean tag, Constants.DeploymentStatus status) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("environment", environment, true).withParam("sha", sha, true).withParam("ref", ref, true).withParam("tag", tag, true).withParam("status", (Object)status, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "deployments"});
        return (Deployment)response.readEntity(Deployment.class);
    }

    public Deployment updateDeployment(Object projectIdOrPath, Long deploymentId, Constants.DeploymentStatus status) throws GitLabApiException {
        if (deploymentId == null) {
            throw new RuntimeException("deploymentId cannot be null");
        }
        Deployment deployment = new Deployment();
        deployment.setStatus(status);
        Response response = this.put(Response.Status.OK, deployment, "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments", deploymentId);
        return (Deployment)response.readEntity(Deployment.class);
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, Long deploymentId) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, deploymentId, this.getDefaultPerPage()).all();
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, Long deploymentId, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments", deploymentId, "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath, Long deploymentId) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, deploymentId, this.getDefaultPerPage()).stream();
    }
}

