/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.gitlab.models.AccessLevel;
import org.miaixz.bus.gitlab.models.GitLabForm;
import org.miaixz.bus.gitlab.models.GitLabFormValue;
import org.miaixz.bus.gitlab.models.Variable;
import org.miaixz.bus.gitlab.support.ISO8601;

public class GitLabApiForm
extends Form {
    public GitLabApiForm() {
    }

    public GitLabApiForm(MultivaluedHashMap<String, String> map) {
        super(map);
    }

    public GitLabApiForm(int page, int perPage) {
        this.withParam("page", page);
        this.withParam("per_page", perPage);
    }

    public GitLabApiForm(GitLabForm form) {
        block6: for (Map.Entry<String, GitLabFormValue> e : form.getFormValues().entrySet()) {
            GitLabFormValue value = e.getValue();
            switch (value.getType()) {
                case ACCESS_LEVEL: {
                    this.withParam(e.getKey(), (AccessLevel)((Object)value.getValue()), value.isRequired());
                    continue block6;
                }
                case DATE: {
                    this.withParam(e.getKey(), (Date)value.getValue(), value.isRequired());
                    continue block6;
                }
                case LIST: {
                    this.withParam(e.getKey(), (List)value.getValue(), value.isRequired());
                    continue block6;
                }
                case MAP: {
                    Map mapValue = (Map)value.getValue();
                    this.withParam(e.getKey(), mapValue, value.isRequired());
                    continue block6;
                }
            }
            this.withParam(e.getKey(), value.getValue(), value.isRequired());
        }
    }

    public GitLabApiForm withParam(String name, Object value) {
        return this.withParam(name, value, false);
    }

    public GitLabApiForm withParam(String name, Date date) {
        return this.withParam(name, date, false);
    }

    public GitLabApiForm withParam(String name, Date date, boolean required) {
        return this.withParam(name, date == null ? null : ISO8601.toString(date), required);
    }

    public GitLabApiForm withParam(String name, AccessLevel level) {
        return this.withParam(name, level, false);
    }

    public GitLabApiForm withParam(String name, AccessLevel level, boolean required) {
        return this.withParam(name, level == null ? null : level.toValue(), required);
    }

    public GitLabApiForm withParam(String name, List<?> values) {
        return this.withParam(name, values, false);
    }

    public GitLabApiForm withParam(String name, List<?> values, boolean required) {
        if (values == null || values.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return this;
        }
        for (Object value : values) {
            if (value == null) continue;
            this.param(name + "[]", value.toString());
        }
        return this;
    }

    public GitLabApiForm withParam(String name, Map<String, ?> variables, boolean required) {
        if (variables == null || variables.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return this;
        }
        for (Map.Entry<String, ?> variable : variables.entrySet()) {
            Object value = variable.getValue();
            if (value == null) continue;
            this.param(name + "[" + variable.getKey() + "]", value.toString());
        }
        return this;
    }

    public GitLabApiForm withParam(String name, Object value, boolean required) {
        if (value == null) {
            if (required) {
                throw new IllegalArgumentException(name + " cannot be empty or null");
            }
            return this;
        }
        String stringValue = value.toString();
        if (required && stringValue.trim().length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty or null");
        }
        this.param(name.trim(), stringValue);
        return this;
    }

    public GitLabApiForm withParam(List<Variable> variables) {
        if (variables == null || variables.isEmpty()) {
            return this;
        }
        variables.forEach(v -> {
            String value = v.getValue();
            if (value != null) {
                this.param("variables[" + v.getKey() + "]", value);
            }
        });
        return this;
    }
}

