/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.ArtifactsFile;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.models.Job;
import org.miaixz.bus.gitlab.models.JobAttributes;

public class JobApi
extends AbstractApi
implements Constants {
    public JobApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Job> getJobs(Object projectIdOrPath) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Job> getJobs(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(this){});
    }

    public Pager<Job> getJobs(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Job>(this, Job.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs");
    }

    public Stream<Job> getJobsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Job> getJobs(Object projectIdOrPath, Constants.JobScope scope) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, scope, this.getDefaultPerPage()).all();
    }

    public Pager<Job> getJobs(Object projectIdOrPath, Constants.JobScope scope, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope);
        return new Pager<Job>(this, Job.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs");
    }

    public Stream<Job> getJobsStream(Object projectIdOrPath, Constants.JobScope scope) throws GitLabApiException {
        return this.getJobs(projectIdOrPath, scope, this.getDefaultPerPage()).stream();
    }

    public List<Job> getJobsForPipeline(Object projectIdOrPath, long pipelineId) throws GitLabApiException {
        return this.getJobsForPipeline(projectIdOrPath, pipelineId, (Boolean)null);
    }

    public List<Job> getJobsForPipeline(Object projectIdOrPath, long pipelineId, Boolean includeRetried) throws GitLabApiException {
        return this.getJobsForPipeline(projectIdOrPath, pipelineId, null, includeRetried);
    }

    public List<Job> getJobsForPipeline(Object projectIdOrPath, long pipelineId, Constants.JobScope scope) throws GitLabApiException {
        return this.getJobsForPipeline(projectIdOrPath, pipelineId, scope, (Boolean)false);
    }

    public List<Job> getJobsForPipeline(Object projectIdOrPath, long pipelineId, Constants.JobScope scope, Boolean includeRetried) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("include_retried", includeRetried).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "jobs");
        return (List)response.readEntity((GenericType)new GenericType<List<Job>>(this){});
    }

    public Pager<Job> getJobsForPipeline(Object projectIdOrPath, long pipelineId, int itemsPerPage) throws GitLabApiException {
        return this.getJobsForPipeline(projectIdOrPath, pipelineId, itemsPerPage, null);
    }

    public Pager<Job> getJobsForPipeline(Object projectIdOrPath, long pipelineId, int itemsPerPage, Boolean includeRetried) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("include_retried", includeRetried).withParam("per_page", this.getDefaultPerPage());
        return new Pager<Job>(this, Job.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "jobs");
    }

    public Stream<Job> getJobsStream(Object projectIdOrPath, long pipelineId) throws GitLabApiException {
        return this.getJobsForPipeline(projectIdOrPath, pipelineId, this.getDefaultPerPage()).stream();
    }

    public Stream<Job> getJobsStream(Object projectIdOrPath, long pipelineId, Boolean includeRetried) throws GitLabApiException {
        return this.getJobsForPipeline(projectIdOrPath, pipelineId, this.getDefaultPerPage(), includeRetried).stream();
    }

    public Job getJob() throws GitLabApiException {
        Constants.TokenType tokenType = this.getApiClient().getTokenType();
        if (tokenType != Constants.TokenType.JOB_TOKEN) {
            throw new IllegalStateException("This method can only be called with a " + String.valueOf((Object)Constants.TokenType.JOB_TOKEN) + " authentication");
        }
        Response response = this.get(Response.Status.OK, null, "job");
        return (Job)response.readEntity(Job.class);
    }

    public Job getJob(String ciJobToken) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job_token", ciJobToken, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "job");
        return (Job)response.readEntity(Job.class);
    }

    public Job getJob(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId);
        return (Job)response.readEntity(Job.class);
    }

    public Optional<Job> getOptionalJob(Object projectIdOrPath, Long jobId) {
        try {
            return Optional.ofNullable(this.getJob(projectIdOrPath, jobId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public File downloadArtifactsFile(Object projectIdOrPath, String ref, String jobName, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job", jobName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", "artifacts", this.urlEncode(ref), "download");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = jobName + "-artifacts.zip";
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Object projectIdOrPath, String ref, String jobName) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("job", jobName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", "artifacts", this.urlEncode(ref), "download");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File downloadArtifactsFile(Object projectIdOrPath, Long jobId, File directory) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = "job-" + jobId + "-artifacts.zip";
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Response response = this.getWithAccepts(Response.Status.OK, null, "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts");
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File downloadArtifactsFile(Object projectIdOrPath, Long jobId, ArtifactsFile artifactsFile, File directory) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", artifactsFile.getFilename());
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = artifactsFile.getFilename();
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadArtifactsFile(Object projectIdOrPath, Long jobId, ArtifactsFile artifactsFile) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", artifactsFile.getFilename());
        return (InputStream)response.readEntity(InputStream.class);
    }

    public File downloadSingleArtifactsFile(Object projectIdOrPath, Long jobId, String artifactPath, File directory) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", artifactPath);
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = artifactPath;
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream downloadSingleArtifactsFile(Object projectIdOrPath, Long jobId, String artifactPath) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts", artifactPath);
        return (InputStream)response.readEntity(InputStream.class);
    }

    public String getTrace(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "trace");
        return (String)response.readEntity(String.class);
    }

    public Job cancelJob(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "cancel"});
        return (Job)response.readEntity(Job.class);
    }

    public Job retryJob(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "retry"});
        return (Job)response.readEntity(Job.class);
    }

    public Job eraseJob(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "erase"});
        return (Job)response.readEntity(Job.class);
    }

    public Job playJob(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        return this.playJob(projectIdOrPath, jobId, null);
    }

    public Job playJob(Object projectIdOrPath, Long jobId, JobAttributes jobAttributes) throws GitLabApiException {
        Response response;
        if (jobAttributes == null) {
            Form formData = null;
            response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "play"});
        } else {
            response = this.post(Response.Status.CREATED, jobAttributes, "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "play");
        }
        return (Job)response.readEntity(Job.class);
    }

    public Job keepArtifacts(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "keep"});
        return (Job)response.readEntity(Job.class);
    }

    public void deleteArtifacts(Object projectIdOrPath, Long jobId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "jobs", jobId, "artifacts");
    }
}

