/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.PagerSpliterator;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.support.JacksonJson;

public class Pager<T>
implements Iterator<List<T>>,
Constants {
    private int itemsPerPage;
    private int totalPages;
    private int totalItems;
    private int currentPage;
    private int kaminariNextPage;
    private List<String> pageParam = new ArrayList<String>(1);
    private List<T> currentItems;
    private Stream<T> pagerStream = null;
    private AbstractApi api;
    private MultivaluedMap<String, String> queryParams;
    private Object[] pathArgs;
    private static JacksonJson jacksonJson = new JacksonJson();
    private static ObjectMapper mapper = jacksonJson.getObjectMapper();
    private JavaType javaType;

    public Pager(AbstractApi api, Class<T> type, int itemsPerPage, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        this.javaType = mapper.getTypeFactory().constructCollectionType(List.class, type);
        if (itemsPerPage < 1) {
            itemsPerPage = api.getDefaultPerPage();
        }
        if (queryParams == null) {
            queryParams = new GitLabApiForm().withParam("per_page", itemsPerPage).asMap();
        } else {
            queryParams.remove((Object)"per_page");
            queryParams.add((Object)"per_page", (Object)Integer.toString(itemsPerPage));
        }
        this.pageParam = new ArrayList<String>();
        this.pageParam.add("1");
        queryParams.put((Object)"page", this.pageParam);
        Response response = api.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams, pathArgs);
        try {
            this.currentItems = (List)mapper.readValue((InputStream)response.getEntity(), this.javaType);
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
        if (this.currentItems == null) {
            throw new GitLabApiException("Invalid response from from GitLab server");
        }
        this.api = api;
        this.queryParams = queryParams;
        this.pathArgs = pathArgs;
        this.itemsPerPage = this.getIntHeaderValue(response, "X-Per-Page");
        if (this.itemsPerPage == -1) {
            this.itemsPerPage = itemsPerPage;
            this.totalPages = 1;
            this.totalItems = this.currentItems.size();
            return;
        }
        this.totalPages = this.getIntHeaderValue(response, "X-Total-Pages");
        this.totalItems = this.getIntHeaderValue(response, "X-Total");
        if (this.totalPages == -1 || this.totalItems == -1) {
            int nextPage = this.getIntHeaderValue(response, "X-Next-Page");
            if (nextPage < 2) {
                this.totalPages = 1;
                this.totalItems = this.currentItems.size();
            } else {
                this.kaminariNextPage = 2;
            }
        }
    }

    private String getHeaderValue(Response response, String key) throws GitLabApiException {
        String value = response.getHeaderString(key);
        String string = value = value != null ? value.trim() : null;
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private int getIntHeaderValue(Response response, String key) throws GitLabApiException {
        String value = this.getHeaderValue(response, key);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new GitLabApiException("Invalid '" + key + "' header value (" + value + ") from server");
        }
    }

    private void setPageParam(int page) {
        this.pageParam.set(0, Integer.toString(page));
        this.queryParams.put((Object)"page", this.pageParam);
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasNext() {
        return this.currentPage < this.totalPages || this.currentPage < this.kaminariNextPage;
    }

    @Override
    public List<T> next() {
        return this.page(this.currentPage + 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<T> first() {
        return this.page(1);
    }

    public List<T> last() throws GitLabApiException {
        if (this.kaminariNextPage != 0) {
            throw new GitLabApiException("Kaminari count limit exceeded, unable to fetch last page");
        }
        return this.page(this.totalPages);
    }

    public List<T> previous() {
        return this.page(this.currentPage - 1);
    }

    public List<T> current() {
        return this.page(this.currentPage);
    }

    public List<T> page(int pageNumber) {
        if (this.currentPage == 0 && pageNumber == 1) {
            this.currentPage = 1;
            return this.currentItems;
        }
        if (this.currentPage == pageNumber) {
            return this.currentItems;
        }
        if (pageNumber > this.totalPages && pageNumber > this.kaminariNextPage) {
            throw new NoSuchElementException();
        }
        if (pageNumber < 1) {
            throw new NoSuchElementException();
        }
        try {
            this.setPageParam(pageNumber);
            Response response = this.api.get(Response.Status.OK, this.queryParams, this.pathArgs);
            this.currentItems = (List)mapper.readValue((InputStream)response.getEntity(), this.javaType);
            this.currentPage = pageNumber;
            if (this.kaminariNextPage > 0) {
                this.kaminariNextPage = this.getIntHeaderValue(response, "X-Next-Page");
            }
            return this.currentItems;
        }
        catch (IOException | GitLabApiException e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> all() throws GitLabApiException {
        this.currentPage = 0;
        ArrayList allItems = new ArrayList(Math.max(this.totalItems, 0));
        while (this.hasNext()) {
            allItems.addAll(this.next());
        }
        return allItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> stream() throws GitLabApiException, IllegalStateException {
        if (this.pagerStream == null) {
            Pager pager = this;
            synchronized (pager) {
                if (this.pagerStream == null) {
                    this.currentPage = 0;
                    Stream.Builder streamBuilder = Stream.builder();
                    while (this.hasNext()) {
                        this.next().forEach(streamBuilder);
                    }
                    this.pagerStream = streamBuilder.build();
                    return this.pagerStream;
                }
            }
        }
        throw new IllegalStateException("Stream already issued");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> lazyStream() throws IllegalStateException {
        if (this.pagerStream == null) {
            Pager pager = this;
            synchronized (pager) {
                if (this.pagerStream == null) {
                    this.currentPage = 0;
                    this.pagerStream = StreamSupport.stream(new PagerSpliterator(this), false);
                    return this.pagerStream;
                }
            }
        }
        throw new IllegalStateException("Stream already issued");
    }
}

