/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Constants;

public class SearchApi
extends AbstractApi {
    public SearchApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public <T> List<T> globalSearch(Constants.SearchScope<T> scope, String search) throws GitLabApiException {
        return this.globalSearch(scope, search, this.getDefaultPerPage()).all();
    }

    public <T> Stream<T> globalSearchStream(Constants.SearchScope<T> scope, String search) throws GitLabApiException {
        return this.globalSearch(scope, search, this.getDefaultPerPage()).stream();
    }

    public <T> Pager<T> globalSearch(Constants.SearchScope<T> scope, String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", scope, true).withParam("search", search, true);
        return new Pager<T>(this, scope.getResultType(), itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "search");
    }

    public <T> List<T> groupSearch(Object groupIdOrPath, Constants.GroupSearchScope<T> scope, String search) throws GitLabApiException {
        return this.groupSearch(groupIdOrPath, scope, search, this.getDefaultPerPage()).all();
    }

    public <T> Stream<T> groupSearchStream(Object groupIdOrPath, Constants.GroupSearchScope<T> scope, String search) throws GitLabApiException {
        return this.groupSearch(groupIdOrPath, scope, search, this.getDefaultPerPage()).stream();
    }

    public <T> Pager<T> groupSearch(Object groupIdOrPath, Constants.GroupSearchScope<T> scope, String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", scope, true).withParam("search", search, true);
        return new Pager<T>(this, scope.getResultType(), itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "search");
    }

    public <T> List<T> projectSearch(Object projectIdOrPath, Constants.ProjectSearchScope<T> scope, String search) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, null, this.getDefaultPerPage()).all();
    }

    public <T> List<T> projectSearch(Object projectIdOrPath, Constants.ProjectSearchScope<T> scope, String search, String ref) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, ref, this.getDefaultPerPage()).all();
    }

    public <T> Stream<T> projectSearchStream(Object projectIdOrPath, Constants.ProjectSearchScope<T> scope, String search) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, null, this.getDefaultPerPage()).stream();
    }

    public <T> Stream<T> projectSearchStream(Object projectIdOrPath, Constants.ProjectSearchScope<T> scope, String search, String ref) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, ref, this.getDefaultPerPage()).stream();
    }

    public <T> Pager<T> projectSearch(Object projectIdOrPath, Constants.ProjectSearchScope<T> scope, String search, int itemsPerPage) throws GitLabApiException {
        return this.projectSearch(projectIdOrPath, scope, search, null, itemsPerPage);
    }

    public <T> Pager<T> projectSearch(Object projectIdOrPath, Constants.ProjectSearchScope<T> scope, String search, String ref, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", scope, true).withParam("search", search, true).withParam("ref", ref, false);
        if (!(ref == null || scope.equals(Constants.ProjectSearchScope.BLOBS) || scope.equals(Constants.ProjectSearchScope.WIKI_BLOBS) || scope.equals(Constants.ProjectSearchScope.COMMITS))) {
            throw new GitLabApiException("Ref parameter is only applicable for scopes: commits, blobs, and wiki_blobs");
        }
        return new Pager<T>(this, scope.getResultType(), itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "search");
    }
}

