/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.HookManager;
import org.miaixz.bus.gitlab.hooks.web.BuildEvent;
import org.miaixz.bus.gitlab.hooks.web.DeploymentEvent;
import org.miaixz.bus.gitlab.hooks.web.Event;
import org.miaixz.bus.gitlab.hooks.web.IssueEvent;
import org.miaixz.bus.gitlab.hooks.web.JobEvent;
import org.miaixz.bus.gitlab.hooks.web.MergeRequestEvent;
import org.miaixz.bus.gitlab.hooks.web.NoteEvent;
import org.miaixz.bus.gitlab.hooks.web.PipelineEvent;
import org.miaixz.bus.gitlab.hooks.web.PushEvent;
import org.miaixz.bus.gitlab.hooks.web.ReleaseEvent;
import org.miaixz.bus.gitlab.hooks.web.TagPushEvent;
import org.miaixz.bus.gitlab.hooks.web.WebHookListener;
import org.miaixz.bus.gitlab.hooks.web.WikiPageEvent;
import org.miaixz.bus.gitlab.hooks.web.WorkItemEvent;
import org.miaixz.bus.gitlab.support.GitlabRequest;
import org.miaixz.bus.gitlab.support.JacksonJson;

public class WebHookManager
implements HookManager {
    private static final Logger LOGGER = Logger.getLogger(WebHookManager.class.getName());
    private final JacksonJson jacksonJson = new JacksonJson();
    private final List<WebHookListener> webhookListeners = new CopyOnWriteArrayList<WebHookListener>();
    private String secretToken;

    public WebHookManager() {
    }

    public WebHookManager(String secretToken) {
        this.secretToken = secretToken;
    }

    @Override
    public String getSecretToken() {
        return this.secretToken;
    }

    @Override
    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    @Override
    public void handleEvent(HttpServletRequest request) throws GitLabApiException {
        this.handleRequest(request);
    }

    public Event handleRequest(HttpServletRequest request) throws GitLabApiException {
        Event event;
        String eventName = request.getHeader("X-Gitlab-Event");
        if (eventName == null || eventName.trim().isEmpty()) {
            LOGGER.warning("X-Gitlab-Event header is missing!");
            return null;
        }
        if (!this.isValidSecretToken(request)) {
            String message = "X-Gitlab-Token mismatch!";
            LOGGER.warning(message);
            throw new GitLabApiException(message);
        }
        LOGGER.info("handleEvent: X-Gitlab-Event=" + eventName);
        switch (eventName) {
            case "Issue Hook": 
            case "Job Hook": 
            case "Merge Request Hook": 
            case "Note Hook": 
            case "Pipeline Hook": 
            case "Push Hook": 
            case "Tag Push Hook": 
            case "Wiki Page Hook": 
            case "Deployment Hook": 
            case "Release Hook": {
                break;
            }
            default: {
                String message = "Unsupported X-Gitlab-Event, event Name=" + eventName;
                LOGGER.warning(message);
                throw new GitLabApiException(message);
            }
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(GitlabRequest.getShortRequestDump(eventName + " webhook", true, request));
                String postData = GitlabRequest.getPostDataAsString(request);
                LOGGER.fine("Raw POST data:\n" + postData);
                event = this.jacksonJson.unmarshal(Event.class, postData);
                LOGGER.fine(event.getObjectKind() + " event:\n" + this.jacksonJson.marshal(event) + "\n");
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
                event = this.jacksonJson.unmarshal(Event.class, reader);
            }
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Error processing JSON data, exception=%s, error=%s", e.getClass().getSimpleName(), e.getMessage()));
            throw new GitLabApiException(e);
        }
        try {
            event.setRequestUrl(request.getRequestURL().toString());
            event.setRequestQueryString(request.getQueryString());
            String secretToken = request.getHeader("X-Gitlab-Token");
            event.setRequestSecretToken(secretToken);
            this.fireEvent(event);
            return event;
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Error processing event, exception=%s, error=%s", e.getClass().getSimpleName(), e.getMessage()));
            throw new GitLabApiException(e);
        }
    }

    public void handleEvent(Event event) throws GitLabApiException {
        LOGGER.info("handleEvent: object_kind=" + event.getObjectKind());
        switch (event.getObjectKind()) {
            case "build": 
            case "issue": 
            case "job": 
            case "merge_request": 
            case "note": 
            case "pipeline": 
            case "push": 
            case "tag_push": 
            case "wiki_page": 
            case "release": 
            case "deployment": 
            case "work_item": {
                this.fireEvent(event);
                break;
            }
            default: {
                String message = "Unsupported event object_kind, object_kind=" + event.getObjectKind();
                LOGGER.warning(message);
                throw new GitLabApiException(message);
            }
        }
    }

    public void addListener(WebHookListener listener) {
        if (!this.webhookListeners.contains(listener)) {
            this.webhookListeners.add(listener);
        }
    }

    public void removeListener(WebHookListener listener) {
        this.webhookListeners.remove(listener);
    }

    public void fireEvent(Event event) throws GitLabApiException {
        switch (event.getObjectKind()) {
            case "build": {
                this.fireBuildEvent((BuildEvent)event);
                break;
            }
            case "issue": {
                this.fireIssueEvent((IssueEvent)event);
                break;
            }
            case "job": {
                this.fireJobEvent((JobEvent)event);
                break;
            }
            case "merge_request": {
                this.fireMergeRequestEvent((MergeRequestEvent)event);
                break;
            }
            case "note": {
                this.fireNoteEvent((NoteEvent)event);
                break;
            }
            case "pipeline": {
                this.firePipelineEvent((PipelineEvent)event);
                break;
            }
            case "push": {
                this.firePushEvent((PushEvent)event);
                break;
            }
            case "tag_push": {
                this.fireTagPushEvent((TagPushEvent)event);
                break;
            }
            case "wiki_page": {
                this.fireWikiPageEvent((WikiPageEvent)event);
                break;
            }
            case "release": {
                this.fireReleaseEvent((ReleaseEvent)event);
                break;
            }
            case "deployment": {
                this.fireDeploymentEvent((DeploymentEvent)event);
                break;
            }
            case "work_item": {
                this.fireWorkItemEvent((WorkItemEvent)event);
                break;
            }
            default: {
                String message = "Unsupported event object_kind, object_kind=" + event.getObjectKind();
                LOGGER.warning(message);
                throw new GitLabApiException(message);
            }
        }
    }

    protected void fireBuildEvent(BuildEvent buildEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onBuildEvent(buildEvent);
        }
    }

    protected void fireIssueEvent(IssueEvent issueEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onIssueEvent(issueEvent);
        }
    }

    protected void fireJobEvent(JobEvent jobEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onJobEvent(jobEvent);
        }
    }

    protected void fireMergeRequestEvent(MergeRequestEvent mergeRequestEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onMergeRequestEvent(mergeRequestEvent);
        }
    }

    protected void fireNoteEvent(NoteEvent noteEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onNoteEvent(noteEvent);
        }
    }

    protected void firePipelineEvent(PipelineEvent pipelineEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onPipelineEvent(pipelineEvent);
        }
    }

    protected void firePushEvent(PushEvent pushEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onPushEvent(pushEvent);
        }
    }

    protected void fireTagPushEvent(TagPushEvent tagPushEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onTagPushEvent(tagPushEvent);
        }
    }

    protected void fireWikiPageEvent(WikiPageEvent wikiPageEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onWikiPageEvent(wikiPageEvent);
        }
    }

    protected void fireDeploymentEvent(DeploymentEvent deploymentEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onDeploymentEvent(deploymentEvent);
        }
    }

    protected void fireWorkItemEvent(WorkItemEvent workItemEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onWorkItemEvent(workItemEvent);
        }
    }

    protected void fireReleaseEvent(ReleaseEvent releaseEvent) {
        for (WebHookListener listener : this.webhookListeners) {
            listener.onReleaseEvent(releaseEvent);
        }
    }
}

