/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Topic;
import org.miaixz.bus.gitlab.models.TopicParams;

public class TopicsApi
extends AbstractApi {
    public TopicsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Topic> getTopics() throws GitLabApiException {
        return this.getTopics(this.getDefaultPerPage()).all();
    }

    public List<Topic> getTopics(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "topics");
        return (List)response.readEntity((GenericType)new GenericType<List<Topic>>(this){});
    }

    public Pager<Topic> getTopics(int itemsPerPage) throws GitLabApiException {
        return new Pager<Topic>(this, Topic.class, itemsPerPage, null, "topics");
    }

    public Stream<Topic> getTopicsStream() throws GitLabApiException {
        return this.getTopics(this.getDefaultPerPage()).stream();
    }

    public Topic getTopic(Integer id) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public Optional<Topic> getOptionalTopic(Integer id) {
        try {
            return Optional.ofNullable(this.getTopic(id));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Topic createTopic(TopicParams params) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)new GitLabApiForm(params.getForm(true)), new Object[]{"topics"});
        return (Topic)response.readEntity(Topic.class);
    }

    public Topic updateTopic(Integer id, TopicParams params) throws GitLabApiException {
        Response response = this.putWithFormData(Response.Status.OK, params.getForm(false), "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public Topic updateTopicAvatar(Integer id, File avatarFile) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", avatarFile, "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public Topic deleteTopicAvatar(Integer id) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", null, "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public void deleteTopic(Integer id) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "topics", id);
    }

    public Topic mergeTopics(Integer sourceTopicId, Integer targetTopicId) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, (Form)new GitLabApiForm().withParam("source_topic_id", sourceTopicId).withParam("target_topic_id", targetTopicId), new Object[]{"topics/merge"});
        return (Topic)response.readEntity(Topic.class);
    }
}

