/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Associations;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.models.CreateRunnerParams;
import org.miaixz.bus.gitlab.models.CreateRunnerResponse;
import org.miaixz.bus.gitlab.models.CustomAttribute;
import org.miaixz.bus.gitlab.models.Email;
import org.miaixz.bus.gitlab.models.Exists;
import org.miaixz.bus.gitlab.models.GpgKey;
import org.miaixz.bus.gitlab.models.ImpersonationToken;
import org.miaixz.bus.gitlab.models.Membership;
import org.miaixz.bus.gitlab.models.SshKey;
import org.miaixz.bus.gitlab.models.User;
import org.miaixz.bus.gitlab.support.EmailChecker;

public class UserApi
extends AbstractApi {
    private boolean customAttributesEnabled = false;

    public UserApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public void enableCustomAttributes() {
        this.customAttributesEnabled = true;
    }

    public void disableCustomAttributes() {
        this.customAttributesEnabled = false;
    }

    public List<User> getUsers() throws GitLabApiException {
        String url = this.gitLabApi.getGitLabServerUrl();
        if (url.startsWith("https://gitlab.com")) {
            GitLabApi.getLogger().warning("Fetching all users from " + url + " may take many minutes to complete, use Pager<User> getUsers(int) instead.");
        }
        return this.getUsers(this.getDefaultPerPage()).all();
    }

    public List<User> getUsers(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage, this.customAttributesEnabled), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(this){});
    }

    public Pager<User> getUsers(int itemsPerPage) throws GitLabApiException {
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)this.createGitLabApiForm().asMap(), "users");
    }

    public Stream<User> getUsersStream() throws GitLabApiException {
        return this.getUsers(this.getDefaultPerPage()).stream();
    }

    public List<User> getActiveUsers() throws GitLabApiException {
        return this.getActiveUsers(this.getDefaultPerPage()).all();
    }

    public List<User> getActiveUsers(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("active", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(this){});
    }

    public Pager<User> getActiveUsers(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("active", true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public Stream<User> getActiveUsersStream() throws GitLabApiException {
        return this.getActiveUsers(this.getDefaultPerPage()).stream();
    }

    public void approveUser(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "approve"});
    }

    public void rejectUser(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.OK, (Form)null, new Object[]{"users", userId, "reject"});
    }

    public void blockUser(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "block"});
    }

    public void unblockUser(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "unblock"});
    }

    public List<User> getBlockedUsers() throws GitLabApiException {
        return this.getBlockedUsers(this.getDefaultPerPage()).all();
    }

    public List<User> getblockedUsers(int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("blocked", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(this){});
    }

    public Pager<User> getBlockedUsers(int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("blocked", true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public Stream<User> getBlockedUsersStream() throws GitLabApiException {
        return this.getBlockedUsers(this.getDefaultPerPage()).stream();
    }

    public User getUser(Long userId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("with_custom_attributes", this.customAttributesEnabled);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", userId);
        return (User)response.readEntity(User.class);
    }

    public Optional<User> getOptionalUser(Long userId) {
        try {
            return Optional.ofNullable(this.getUser(userId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUser(String username) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("username", username, true).withParam("page", 1).withParam("per_page", 1);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        List users = (List)response.readEntity((GenericType)new GenericType<List<User>>(this){});
        return users.isEmpty() ? null : (User)users.get(0);
    }

    public Optional<User> getOptionalUser(String username) {
        try {
            return Optional.ofNullable(this.getUser(username));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUserByEmail(String email) throws GitLabApiException {
        if (!EmailChecker.isValidEmail(email)) {
            throw new IllegalArgumentException("email is not valid");
        }
        List<User> users = this.findUsers(email, 1, 1);
        return users.isEmpty() ? null : users.get(0);
    }

    public Optional<User> getOptionalUserByEmail(String email) {
        try {
            return Optional.ofNullable(this.getUserByEmail(email));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public User getUserByExternalUid(String provider, String externalUid) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("provider", provider, true).withParam("extern_uid", externalUid, true).withParam("page", 1).withParam("per_page", 1);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        List users = (List)response.readEntity((GenericType)new GenericType<List<User>>(this){});
        return users.isEmpty() ? null : (User)users.get(0);
    }

    public Optional<User> getOptionalUserByExternalUid(String provider, String externalUid) {
        try {
            return Optional.ofNullable(this.getUserByExternalUid(provider, externalUid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<User> findUsers(String emailOrUsername) throws GitLabApiException {
        return this.findUsers(emailOrUsername, this.getDefaultPerPage()).all();
    }

    public List<User> findUsers(String emailOrUsername, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("search", emailOrUsername, true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users");
        return (List)response.readEntity((GenericType)new GenericType<List<User>>(this){});
    }

    public Pager<User> findUsers(String emailOrUsername, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = this.createGitLabApiForm().withParam("search", emailOrUsername, true);
        return new Pager<User>(this, User.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users");
    }

    public Stream<User> findUsersStream(String emailOrUsername) throws GitLabApiException {
        return this.findUsers(emailOrUsername, this.getDefaultPerPage()).stream();
    }

    public User createUser(User user, CharSequence password, Boolean resetPassword) throws GitLabApiException {
        Form formData = this.userToForm(user, null, password, resetPassword, true);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"users"});
        return (User)response.readEntity(User.class);
    }

    public User updateUser(User user, CharSequence password) throws GitLabApiException {
        Form form = this.userToForm(user, null, password, false, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"users", user.getId()});
        return (User)response.readEntity(User.class);
    }

    public void deleteUser(Object userIdOrUsername) throws GitLabApiException {
        this.deleteUser(userIdOrUsername, null);
    }

    public void deleteUser(Object userIdOrUsername, Boolean hardDelete) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("hard_delete ", hardDelete);
        this.delete(Response.Status.NO_CONTENT, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername));
    }

    public User getCurrentUser() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user");
        return (User)response.readEntity(User.class);
    }

    public List<SshKey> getSshKeys() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "user", "keys");
        return (List)response.readEntity((GenericType)new GenericType<List<SshKey>>(this){});
    }

    public List<SshKey> getSshKeys(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "users", userId, "keys");
        List keys = (List)response.readEntity((GenericType)new GenericType<List<SshKey>>(this){});
        if (keys != null) {
            keys.forEach(key -> key.setUserId(userId));
        }
        return keys;
    }

    public SshKey getSshKey(Long keyId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user", "keys", keyId);
        return (SshKey)response.readEntity(SshKey.class);
    }

    public Optional<SshKey> getOptionalSshKey(Long keyId) {
        try {
            return Optional.ofNullable(this.getSshKey(keyId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public SshKey addSshKey(String title, String key, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("key", key).withParam("expires_at", expiresAt);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", "keys"});
        return (SshKey)response.readEntity(SshKey.class);
    }

    public SshKey addSshKey(Long userId, String title, String key, Date expiresAt) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("key", key).withParam("expires_at", expiresAt);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", userId, "keys"});
        SshKey sshKey = (SshKey)response.readEntity(SshKey.class);
        if (sshKey != null) {
            sshKey.setUserId(userId);
        }
        return sshKey;
    }

    public void deleteSshKey(Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "user", "keys", keyId);
    }

    public void deleteSshKey(Object userIdOrUsername, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "users", this.getUserIdOrUsername(userIdOrUsername), "keys", keyId);
    }

    public List<ImpersonationToken> getImpersonationTokens(Object userIdOrUsername) throws GitLabApiException {
        return this.getImpersonationTokens(userIdOrUsername, null);
    }

    public List<ImpersonationToken> getImpersonationTokens(Object userIdOrUsername, Constants.ImpersonationState state) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens");
        return (List)response.readEntity((GenericType)new GenericType<List<ImpersonationToken>>(this){});
    }

    public ImpersonationToken getImpersonationToken(Object userIdOrUsername, Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens", tokenId);
        return (ImpersonationToken)response.readEntity(ImpersonationToken.class);
    }

    public Optional<ImpersonationToken> getOptionalImpersonationToken(Object userIdOrUsername, Long tokenId) {
        try {
            return Optional.ofNullable(this.getImpersonationToken(userIdOrUsername, tokenId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public ImpersonationToken createImpersonationToken(Object userIdOrUsername, String name, Date expiresAt, ImpersonationToken.Scope[] scopes) throws GitLabApiException {
        return this.createPersonalAccessTokenOrImpersonationToken(userIdOrUsername, name, null, expiresAt, scopes, true);
    }

    public void revokeImpersonationToken(Object userIdOrUsername, Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "users", this.getUserIdOrUsername(userIdOrUsername), "impersonation_tokens", tokenId);
    }

    public ImpersonationToken createPersonalAccessToken(Object userIdOrUsername, String name, String description, Date expiresAt, ImpersonationToken.Scope[] scopes) throws GitLabApiException {
        return this.createPersonalAccessTokenOrImpersonationToken(userIdOrUsername, name, description, expiresAt, scopes, false);
    }

    public void revokePersonalAccessToken(Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "personal_access_tokens", tokenId);
    }

    private ImpersonationToken createPersonalAccessTokenOrImpersonationToken(Object userIdOrUsername, String name, String description, Date expiresAt, ImpersonationToken.Scope[] scopes, boolean impersonation) throws GitLabApiException {
        if (scopes == null || scopes.length == 0) {
            throw new RuntimeException("scopes cannot be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("description", description).withParam("expires_at", expiresAt);
        for (ImpersonationToken.Scope scope : scopes) {
            formData.withParam("scopes[]", scope.toString());
        }
        String tokenTypePathArg = impersonation ? "impersonation_tokens" : "personal_access_tokens";
        Response response = userIdOrUsername != null ? this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", this.getUserIdOrUsername(userIdOrUsername), tokenTypePathArg}) : this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", tokenTypePathArg});
        return (ImpersonationToken)response.readEntity(ImpersonationToken.class);
    }

    public ImpersonationToken createPersonalAccessToken(String name, String description, Date expiresAt, ImpersonationToken.Scope[] scopes) throws GitLabApiException {
        return this.createPersonalAccessTokenOrImpersonationToken(null, name, description, expiresAt, scopes, false);
    }

    Form userToForm(User user, Integer projectsLimit, CharSequence password, Boolean resetPassword, boolean create) {
        if (create && (password == null || password.toString().trim().isEmpty()) && !resetPassword.booleanValue()) {
            throw new IllegalArgumentException("either password or reset_password must be set");
        }
        projectsLimit = projectsLimit == null ? user.getProjectsLimit() : projectsLimit;
        String skipConfirmationFeildName = create ? "skip_confirmation" : "skip_reconfirmation";
        return new GitLabApiForm().withParam("public_email", user.getPublicEmail(), false).withParam("email", user.getEmail(), create).withParam("password", password, false).withParam("reset_password", resetPassword, false).withParam("username", user.getUsername(), create).withParam("name", user.getName(), create).withParam("skype", user.getSkype(), false).withParam("linkedin", user.getLinkedin(), false).withParam("twitter", user.getTwitter(), false).withParam("website_url", user.getWebsiteUrl(), false).withParam("organization", user.getOrganization(), false).withParam("projects_limit", projectsLimit, false).withParam("extern_uid", user.getExternUid(), false).withParam("provider", user.getProvider(), false).withParam("bio", user.getBio(), false).withParam("location", user.getLocation(), false).withParam("admin", user.getIsAdmin(), false).withParam("theme_id", user.getThemeId(), false).withParam("color_scheme_id", user.getColorSchemeId(), false).withParam("can_create_group", user.getCanCreateGroup(), false).withParam(skipConfirmationFeildName, user.getSkipConfirmation(), false).withParam("external", user.getExternal(), false).withParam("shared_runners_minutes_limit", user.getSharedRunnersMinutesLimit(), false);
    }

    public CustomAttribute createCustomAttribute(Object userIdOrUsername, CustomAttribute customAttribute) throws GitLabApiException {
        if (Objects.isNull(customAttribute)) {
            throw new IllegalArgumentException("CustomAttributes can't be null");
        }
        return this.createCustomAttribute(userIdOrUsername, customAttribute.getKey(), customAttribute.getValue());
    }

    public CustomAttribute createCustomAttribute(Object userIdOrUsername, String key, String value) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key can't be null or empty");
        }
        if (Objects.isNull(value) || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Value can't be null or empty");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"users", this.getUserIdOrUsername(userIdOrUsername), "custom_attributes", key});
        return (CustomAttribute)response.readEntity(CustomAttribute.class);
    }

    public CustomAttribute changeCustomAttribute(Object userIdOrUsername, CustomAttribute customAttribute) throws GitLabApiException {
        if (Objects.isNull(customAttribute)) {
            throw new IllegalArgumentException("CustomAttributes can't be null");
        }
        return this.createCustomAttribute(userIdOrUsername, customAttribute.getKey(), customAttribute.getValue());
    }

    public CustomAttribute changeCustomAttribute(Object userIdOrUsername, String key, String value) throws GitLabApiException {
        return this.createCustomAttribute(userIdOrUsername, key, value);
    }

    public void deleteCustomAttribute(Object userIdOrUsername, CustomAttribute customAttribute) throws GitLabApiException {
        if (Objects.isNull(customAttribute)) {
            throw new IllegalArgumentException("customAttributes can't be null");
        }
        this.deleteCustomAttribute(userIdOrUsername, customAttribute.getKey());
    }

    public void deleteCustomAttribute(Object userIdOrUsername, String key) throws GitLabApiException {
        if (Objects.isNull(key) || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Key can't be null or empty");
        }
        this.delete(Response.Status.OK, null, "users", this.getUserIdOrUsername(userIdOrUsername), "custom_attributes", key);
    }

    private GitLabApiForm createGitLabApiForm() {
        GitLabApiForm formData = new GitLabApiForm();
        return this.customAttributesEnabled ? formData.withParam("with_custom_attributes", true) : formData;
    }

    public User setUserAvatar(Object userIdOrUsername, File avatarFile) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", avatarFile, "users", this.getUserIdOrUsername(userIdOrUsername));
        return (User)response.readEntity(User.class);
    }

    public List<Email> getEmails() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user", "emails");
        return (List)response.readEntity((GenericType)new GenericType<List<Email>>(this){});
    }

    public List<Email> getEmails(Object userIdOrUsername) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", this.getUserIdOrUsername(userIdOrUsername), "emails");
        return (List)response.readEntity((GenericType)new GenericType<List<Email>>(this){});
    }

    public Email addEmail(String email) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("email", email, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", "emails"});
        return (Email)response.readEntity(Email.class);
    }

    public Email getEmail(Long emailId) throws GitLabApiException {
        Response response = this.get(Response.Status.CREATED, null, "user", "emails", emailId);
        return (Email)response.readEntity(Email.class);
    }

    public Email addEmail(Object userIdOrUsername, String email, Boolean skipConfirmation) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("email", email, true).withParam("skip_confirmation ", skipConfirmation);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", this.getUserIdOrUsername(userIdOrUsername), "emails"});
        return (Email)response.readEntity(Email.class);
    }

    public void deleteEmail(Long emailId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "user", "emails", emailId);
    }

    public void deleteEmail(Object userIdOrUsername, Long emailId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "users", this.getUserIdOrUsername(userIdOrUsername), "emails", emailId);
    }

    public List<GpgKey> listGpgKeys() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "user", "gpg_keys");
        return (List)response.readEntity((GenericType)new GenericType<List<GpgKey>>(this){});
    }

    public GpgKey addGpgKey(String key) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("key", key, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"user", "gpg_keys"});
        return (GpgKey)response.readEntity(GpgKey.class);
    }

    public void deleteGpgKey(Long keyId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "user", "gpg_keys", keyId);
    }

    public List<GpgKey> listGpgKeys(Long userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", userId, "gpg_keys");
        return (List)response.readEntity((GenericType)new GenericType<List<GpgKey>>(this){});
    }

    public GpgKey addGpgKey(Long userId, String key) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("key", key, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"users", userId, "gpg_keys"});
        return (GpgKey)response.readEntity(GpgKey.class);
    }

    public void deleteGpgKey(Long userId, Long keyId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "users", userId, "gpg_keys", keyId);
    }

    public List<Membership> getMemberships(Long userId) throws GitLabApiException {
        return this.getMemberships(userId, this.getDefaultPerPage()).all();
    }

    public Pager<Membership> getMemberships(Long userId, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        return new Pager<Membership>(this, Membership.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "users", userId, "memberships");
    }

    public Associations getAssociationsCount(Long userId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "users", userId, "associations_count");
        return (Associations)response.readEntity(Associations.class);
    }

    public void activateUser(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "activate"});
    }

    public void deactivateUser(Long userId) throws GitLabApiException {
        if (userId == null) {
            throw new RuntimeException("userId cannot be null");
        }
        this.post(Response.Status.CREATED, (Form)null, new Object[]{"users", userId, "deactivate"});
    }

    public boolean exists(String username) throws GitLabApiException {
        if (username == null) {
            throw new RuntimeException("username cannot be null");
        }
        try {
            Response response = this.get(Response.Status.OK, null, this.getApiClient().getUrlWithBase("users", username, "exists"));
            return ((Exists)response.readEntity(Exists.class)).getExists();
        }
        catch (IOException e) {
            throw new GitLabApiException(e);
        }
    }

    public CreateRunnerResponse createRunner(CreateRunnerParams params) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm(params.getForm()).asMap(), new Object[]{"user", "runners"});
        return (CreateRunnerResponse)response.readEntity(CreateRunnerResponse.class);
    }
}

