/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.miaixz.bus.gitlab.models.Author;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.models.Issue;
import org.miaixz.bus.gitlab.models.MergeRequest;
import org.miaixz.bus.gitlab.models.Project;
import org.miaixz.bus.gitlab.support.JacksonJson;

public class Todo
implements Serializable {
    private static final long serialVersionUID = 2852282035620L;
    private Long id;
    private Project project;
    private Author author;
    private Constants.TodoAction actionName;
    private Constants.TodoType targetType;
    @JsonDeserialize(using=TargetDeserializer.class)
    private Object target;
    private String targetUrl;
    private String body;
    private Constants.TodoState state;
    private Date createdAt;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public Constants.TodoAction getActionName() {
        return this.actionName;
    }

    public void setActionName(Constants.TodoAction actionName) {
        this.actionName = actionName;
    }

    public Constants.TodoType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Constants.TodoType targetType) {
        this.targetType = targetType;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Constants.TodoState getState() {
        return this.state;
    }

    public void setState(Constants.TodoState state) {
        this.state = state;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public Issue getIssueTarget() {
        return this.targetType == Constants.TodoType.ISSUE ? (Issue)this.target : null;
    }

    @JsonIgnore
    public MergeRequest getMergeRequestTarget() {
        return this.targetType == Constants.TodoType.MERGE_REQUEST ? (MergeRequest)this.target : null;
    }

    @JsonIgnore
    public boolean isIssueTodo() {
        return this.targetType == Constants.TodoType.ISSUE;
    }

    @JsonIgnore
    public boolean isMergeRequestTodo() {
        return this.targetType == Constants.TodoType.MERGE_REQUEST;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }

    private static class TargetDeserializer
    extends JsonDeserializer<Object> {
        private TargetDeserializer() {
        }

        public Object deserialize(JsonParser jp, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            ObjectNode root = (ObjectNode)mapper.readTree(jp);
            boolean isMergeRequestTarget = root.has("source_branch");
            if (isMergeRequestTarget) {
                return mapper.treeToValue((TreeNode)root, MergeRequest.class);
            }
            return mapper.treeToValue((TreeNode)root, Issue.class);
        }
    }
}

