/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.support.JacksonJson;
import org.miaixz.bus.gitlab.support.MaskingLoggingFilter;

public class GitLabApiClient
implements AutoCloseable {
    protected static final String PRIVATE_TOKEN_HEADER = "PRIVATE-TOKEN";
    protected static final String JOB_TOKEN_HEADER = "JOB-TOKEN";
    protected static final String SUDO_HEADER = "Sudo";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String X_GITLAB_TOKEN_HEADER = "X-Gitlab-Token";
    private ClientConfig clientConfig;
    private Client apiClient;
    private String baseUrl;
    private String hostUrl;
    private Constants.TokenType tokenType = Constants.TokenType.PRIVATE;
    private Supplier<String> authToken;
    private String secretToken;
    private boolean ignoreCertificateErrors;
    private SSLContext openSslContext;
    private HostnameVerifier openHostnameVerifier;
    private Long sudoAsId;
    private Integer connectTimeout;
    private Integer readTimeout;
    private String userAgentHeader;

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(apiVersion, hostUrl, tokenType, authToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, null);
    }

    public GitLabApiClient(String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, tokenType, authToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, null);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(apiVersion, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken, String secretToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(GitLabApi.ApiVersion.V4, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApiClient(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(GitLabApi.ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApiClient(GitLabApi.ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.baseUrl = this.hostUrl = hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl;
        this.hostUrl = this.hostUrl + apiVersion.getApiNamespace();
        this.tokenType = tokenType;
        this.authToken = () -> authToken;
        if (secretToken != null) {
            secretToken = (secretToken = secretToken.trim()).length() > 0 ? secretToken : null;
        }
        this.secretToken = secretToken;
        this.clientConfig = new ClientConfig();
        if (clientConfigProperties != null) {
            for (Map.Entry<String, Object> propertyEntry : clientConfigProperties.entrySet()) {
                this.clientConfig.property(propertyEntry.getKey(), propertyEntry.getValue());
            }
        }
        this.clientConfig.property("jersey.config.client.disableAutoDiscovery", (Object)true);
        this.clientConfig.property("jersey.config.client.disableMetainfServicesLookup", (Object)true);
        this.clientConfig.register(JacksonJson.class);
        this.clientConfig.register(MultiPartFeature.class);
    }

    @Override
    public void close() {
        if (this.apiClient != null) {
            this.apiClient.close();
        }
    }

    void enableRequestResponseLogging(Logger logger, Level level, int maxEntityLength, List<String> maskedHeaderNames) {
        MaskingLoggingFilter loggingFilter = new MaskingLoggingFilter(logger, level, maxEntityLength, maskedHeaderNames);
        this.clientConfig.register((Object)loggingFilter);
        if (this.apiClient != null) {
            this.createApiClient();
        }
    }

    void setRequestTimeout(Integer connectTimeout, Integer readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    String getAuthToken() {
        return this.authToken.get();
    }

    String getSecretToken() {
        return this.secretToken;
    }

    Constants.TokenType getTokenType() {
        return this.tokenType;
    }

    Long getSudoAsId() {
        return this.sudoAsId;
    }

    void setSudoAsId(Long sudoAsId) {
        this.sudoAsId = sudoAsId;
    }

    protected URL getApiUrl(Object ... pathArgs) throws IOException {
        String url = this.appendPathArgs(this.hostUrl, pathArgs);
        return new URL(url);
    }

    protected URL getUrlWithBase(Object ... pathArgs) throws IOException {
        String url = this.appendPathArgs(this.baseUrl, pathArgs);
        return new URL(url);
    }

    private String appendPathArgs(String url, Object ... pathArgs) {
        StringBuilder urlBuilder = new StringBuilder(url);
        for (Object pathArg : pathArgs) {
            if (pathArg == null) continue;
            urlBuilder.append("/");
            urlBuilder.append(pathArg.toString());
        }
        return urlBuilder.toString();
    }

    protected boolean validateSecretToken(Response response) {
        if (this.secretToken == null) {
            return true;
        }
        String secretToken = response.getHeaderString(X_GITLAB_TOKEN_HEADER);
        if (secretToken == null) {
            return false;
        }
        return this.secretToken.equals(secretToken);
    }

    protected Response get(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.get(queryParams, url);
    }

    protected Response get(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).get();
    }

    protected Response getWithAccepts(MultivaluedMap<String, String> queryParams, String accepts, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.getWithAccepts(queryParams, url, accepts);
    }

    protected Response getWithAccepts(MultivaluedMap<String, String> queryParams, URL url, String accepts) {
        return this.invocation(url, queryParams, accepts).get();
    }

    protected Response head(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.head(queryParams, url);
    }

    protected Response head(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).head();
    }

    protected Response patch(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.patch(queryParams, url);
    }

    protected Response patch(MultivaluedMap<String, String> queryParams, URL url) {
        Entity empty = Entity.text((Object)"");
        return this.invocation(url, queryParams).header("X-HTTP-Method-Override", (Object)"PATCH").post(empty);
    }

    protected Response post(Form formData, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.post(formData, url);
    }

    protected Response post(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.post(queryParams, url);
    }

    protected Response post(Form formData, URL url) {
        if (formData instanceof GitLabApiForm) {
            return this.invocation(url, null).post(Entity.entity((Object)formData.asMap(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        }
        if (formData != null) {
            return this.invocation(url, null).post(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        }
        return this.invocation(url, null).post(Entity.entity((Object)new Form(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response post(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).post(Entity.entity((Object)new Form(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response post(Object payload, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        Entity entity = Entity.entity((Object)payload, (String)"application/json");
        return this.invocation(url, null).post(entity);
    }

    protected Response post(StreamingOutput stream, String mediaType, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.invocation(url, null).post(Entity.entity((Object)stream, (String)mediaType));
    }

    protected Response upload(String name, File fileToUpload, String mediaTypeString, Object ... pathArgs) throws IOException {
        return this.upload(name, fileToUpload, mediaTypeString, null, pathArgs);
    }

    protected Response upload(String name, File fileToUpload, String mediaTypeString, Form formData, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.upload(name, fileToUpload, mediaTypeString, formData, url);
    }

    protected Response upload(String name, File fileToUpload, String mediaTypeString, Form formData, URL url) throws IOException {
        FileDataBodyPart filePart = new FileDataBodyPart(name, fileToUpload);
        return this.upload((BodyPart)filePart, formData, url);
    }

    protected Response upload(String name, InputStream inputStream, String filename, String mediaTypeString, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.upload(name, inputStream, filename, mediaTypeString, null, url);
    }

    protected Response upload(String name, InputStream inputStream, String filename, String mediaTypeString, Form formData, URL url) throws IOException {
        StreamDataBodyPart streamDataBodyPart = new StreamDataBodyPart(name, inputStream, filename);
        return this.upload((BodyPart)streamDataBodyPart, formData, url);
    }

    protected Response upload(BodyPart bodyPart, Form formData, URL url) throws IOException {
        try (FormDataMultiPart multiPart = new FormDataMultiPart();){
            if (formData != null) {
                formData.asMap().forEach((key, values) -> {
                    if (values != null) {
                        values.forEach(value -> multiPart.field(key, value));
                    }
                });
            }
            multiPart.bodyPart(bodyPart);
            Entity entity = Entity.entity((Object)multiPart, (MediaType)Boundary.addBoundary((MediaType)multiPart.getMediaType()));
            Response response = this.invocation(url, null).post(entity);
            return response;
        }
    }

    protected Response putUpload(String name, File fileToUpload, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.putUpload(name, fileToUpload, url);
    }

    protected Response putUpload(String name, File fileToUpload, URL url) throws IOException {
        try (FormDataMultiPart multiPart = new FormDataMultiPart();){
            if (fileToUpload == null) {
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(name, (Object)"", MediaType.APPLICATION_OCTET_STREAM_TYPE));
            } else {
                multiPart.bodyPart((BodyPart)new FileDataBodyPart(name, fileToUpload, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            }
            Entity entity = Entity.entity((Object)multiPart, (MediaType)Boundary.addBoundary((MediaType)multiPart.getMediaType()));
            Response response = this.invocation(url, null).put(entity);
            return response;
        }
    }

    protected Response put(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.put(queryParams, url);
    }

    protected Response put(MultivaluedMap<String, String> queryParams, URL url) {
        if (queryParams == null || queryParams.isEmpty()) {
            Entity empty = Entity.text((Object)"");
            return this.invocation(url, null).put(empty);
        }
        return this.invocation(url, null).put(Entity.entity(queryParams, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response put(Form formData, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        return this.put(formData, url);
    }

    protected Response put(Form formData, URL url) {
        if (formData instanceof GitLabApiForm) {
            return this.invocation(url, null).put(Entity.entity((Object)formData.asMap(), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        }
        return this.invocation(url, null).put(Entity.entity((Object)formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response put(Object payload, Object ... pathArgs) throws IOException {
        URL url = this.getApiUrl(pathArgs);
        Entity entity = Entity.entity((Object)payload, (String)"application/json");
        return this.invocation(url, null).put(entity);
    }

    protected Response delete(MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws IOException {
        return this.delete(queryParams, this.getApiUrl(pathArgs));
    }

    protected Response delete(MultivaluedMap<String, String> queryParams, URL url) {
        return this.invocation(url, queryParams).delete();
    }

    protected Invocation.Builder invocation(URL url, MultivaluedMap<String, String> queryParams) {
        return this.invocation(url, queryParams, "application/json");
    }

    protected Client createApiClient() {
        JerseyClientBuilder clientBuilder = new JerseyClientBuilder().withConfig((Configuration)this.clientConfig);
        clientBuilder.register(JacksonJson.class);
        if (this.ignoreCertificateErrors) {
            clientBuilder.sslContext(this.openSslContext).hostnameVerifier(this.openHostnameVerifier);
        }
        this.apiClient = clientBuilder.build();
        return this.apiClient;
    }

    protected Invocation.Builder invocation(URL url, MultivaluedMap<String, String> queryParams, String accept) {
        if (this.apiClient == null) {
            this.createApiClient();
        }
        WebTarget target = (WebTarget)this.apiClient.target(url.toExternalForm()).property("jersey.config.client.followRedirects", (Object)true);
        if (queryParams != null) {
            for (Map.Entry param : queryParams.entrySet()) {
                target = target.queryParam((String)param.getKey(), ((List)param.getValue()).toArray());
            }
        }
        String authHeader = this.getAuthHeader();
        String authValue = this.getAuthValue();
        Invocation.Builder builder = target.request();
        builder = accept == null || accept.trim().length() == 0 ? builder.header(authHeader, (Object)authValue) : builder.header(authHeader, (Object)authValue).accept(new String[]{accept});
        if (this.userAgentHeader != null) {
            builder.header("User-Agent", (Object)this.userAgentHeader);
        }
        if (this.sudoAsId != null && this.sudoAsId.intValue() > 0) {
            builder = builder.header(SUDO_HEADER, (Object)this.sudoAsId);
        }
        if (this.connectTimeout != null) {
            builder.property("jersey.config.client.connectTimeout", (Object)this.connectTimeout);
        }
        if (this.readTimeout != null) {
            builder.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
        }
        return builder;
    }

    private String getAuthValue() {
        switch (this.tokenType) {
            case OAUTH2_ACCESS: {
                return "Bearer " + this.authToken.get();
            }
        }
        return this.authToken.get();
    }

    private String getAuthHeader() {
        switch (this.tokenType) {
            case OAUTH2_ACCESS: {
                return AUTHORIZATION_HEADER;
            }
            case JOB_TOKEN: {
                return JOB_TOKEN_HEADER;
            }
        }
        return PRIVATE_TOKEN_HEADER;
    }

    void setHostUrlToBaseUrl() {
        this.hostUrl = this.baseUrl;
    }

    public boolean getIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        if (this.ignoreCertificateErrors == ignoreCertificateErrors) {
            return;
        }
        if (!ignoreCertificateErrors) {
            this.ignoreCertificateErrors = false;
            this.openSslContext = null;
            this.openHostnameVerifier = null;
            this.apiClient = null;
        } else if (this.setupIgnoreCertificateErrors()) {
            this.ignoreCertificateErrors = true;
            this.apiClient = null;
        } else {
            this.ignoreCertificateErrors = false;
            this.apiClient = null;
            throw new RuntimeException("Unable to ignore certificate errors.");
        }
    }

    public String getUserAgentHeader() {
        return this.userAgentHeader;
    }

    public void setUserAgentHeader(String userAgentHeader) {
        this.userAgentHeader = userAgentHeader;
    }

    private boolean setupIgnoreCertificateErrors() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
            }
        }};
        HostnameVerifier hostnameVerifier = (hostname, session) -> true;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            this.openSslContext = sslContext;
            this.openHostnameVerifier = hostnameVerifier;
        }
        catch (GeneralSecurityException ex) {
            this.openSslContext = null;
            this.openHostnameVerifier = null;
            return false;
        }
        return true;
    }

    public void setAuthTokenSupplier(Supplier<String> authTokenSupplier) {
        this.authToken = authTokenSupplier;
    }
}

