/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Label;

public class LabelsApi
extends AbstractApi {
    public LabelsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Label> getProjectLabels(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectLabels(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Label> getProjectLabels(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Label>(this, Label.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels");
    }

    public Stream<Label> getProjectLabelsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectLabels(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Label getProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return (Label)response.readEntity(Label.class);
    }

    public Optional<Label> getOptionalProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getProjectLabel(projectIdOrPath, labelIdOrName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Label createProjectLabel(Object projectIdOrPath, Label labelProperties) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelProperties.getForm(true));
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "labels"});
        return (Label)response.readEntity(Label.class);
    }

    public Label updateProjectLabel(Object projectIdOrPath, Object labelIdOrName, Label labelConfig) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelConfig.getForm(false));
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return (Label)response.readEntity(Label.class);
    }

    public void deleteProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
    }

    public Label subscribeProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "subscribe"});
        return (Label)response.readEntity(Label.class);
    }

    public Label unsubscribeProjectLabel(Object projectIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "unsubscribe"});
        return (Label)response.readEntity(Label.class);
    }

    public List<Label> getGroupLabels(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupLabels(groupIdOrPath, this.getDefaultPerPage()).all();
    }

    public Pager<Label> getGroupLabels(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Label>(this, Label.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels");
    }

    public Stream<Label> getGroupLabelsStream(Object groupIdOrPath) throws GitLabApiException {
        return this.getGroupLabels(groupIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Label getGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return (Label)response.readEntity(Label.class);
    }

    public Optional<Label> getOptionalGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        try {
            return Optional.ofNullable(this.getGroupLabel(groupIdOrPath, labelIdOrName));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Label createGroupLabel(Object groupIdOrPath, Label labelProperties) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelProperties.getForm(true));
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "labels"});
        return (Label)response.readEntity(Label.class);
    }

    public Label updateGroupLabel(Object groupIdOrPath, Object labelIdOrName, Label labelConfig) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(labelConfig.getForm(false));
        Response response = this.putWithFormData(Response.Status.OK, formData, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
        return (Label)response.readEntity(Label.class);
    }

    public void deleteGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName));
    }

    public Label subscribeGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "subscribe"});
        return (Label)response.readEntity(Label.class);
    }

    public Label unsubscribeGroupLabel(Object groupIdOrPath, Object labelIdOrName) throws GitLabApiException {
        Response response = this.post(Response.Status.NOT_MODIFIED, this.getDefaultPerPageParam(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "labels", this.getLabelIdOrName(labelIdOrName), "unsubscribe"});
        return (Label)response.readEntity(Label.class);
    }
}

