/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.Blame;
import org.miaixz.bus.gitlab.models.Constants;
import org.miaixz.bus.gitlab.models.RepositoryFile;
import org.miaixz.bus.gitlab.models.RepositoryFileResponse;

public class RepositoryFileApi
extends AbstractApi {
    public RepositoryFileApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public Optional<RepositoryFile> getOptionalFileInfo(Object projectIdOrPath, String filePath, String ref) {
        try {
            return Optional.ofNullable(this.getFileInfo(projectIdOrPath, filePath, ref));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public RepositoryFile getFileInfo(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        Form form = new Form();
        this.addFormParam(form, "ref", ref != null ? this.urlEncode(ref) : null, true);
        Response response = this.head(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        RepositoryFile file = new RepositoryFile();
        file.setBlobId(response.getHeaderString("X-Gitlab-Blob-Id"));
        file.setCommitId(response.getHeaderString("X-Gitlab-Commit-Id"));
        file.setContentSha256(response.getHeaderString("X-Gitlab-Content-Sha256"));
        String encoding = response.getHeaderString("X-Gitlab-Encoding");
        file.setEncoding(Constants.Encoding.forValue(encoding));
        file.setFileName(response.getHeaderString("X-Gitlab-File-Name"));
        file.setFilePath(response.getHeaderString("X-Gitlab-File-Path"));
        file.setLastCommitId(response.getHeaderString("X-Gitlab-Last-Commit-Id"));
        file.setRef(response.getHeaderString("X-Gitlab-Ref"));
        String sizeStr = response.getHeaderString("X-Gitlab-Size");
        file.setSize(sizeStr != null ? Integer.valueOf(sizeStr) : -1);
        return file;
    }

    public Optional<RepositoryFile> getOptionalFile(Object projectIdOrPath, String filePath, String ref) {
        try {
            return Optional.ofNullable(this.getFile(projectIdOrPath, filePath, ref, true));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public RepositoryFile getFile(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getFile(projectIdOrPath, filePath, ref, true);
    }

    public RepositoryFile getFile(Object projectIdOrPath, String filePath, String ref, boolean includeContent) throws GitLabApiException {
        if (!includeContent) {
            return this.getFileInfo(projectIdOrPath, filePath, ref);
        }
        Form form = new Form();
        this.addFormParam(form, "ref", ref != null ? this.urlEncode(ref) : null, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFileResponse createFile(Object projectIdOrPath, RepositoryFile file, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(file.getFilePath())});
        return (RepositoryFileResponse)response.readEntity(RepositoryFileResponse.class);
    }

    public RepositoryFileResponse updateFile(Object projectIdOrPath, RepositoryFile file, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(file.getFilePath())});
        return (RepositoryFileResponse)response.readEntity(RepositoryFileResponse.class);
    }

    public void deleteFile(Object projectIdOrPath, String filePath, String branchName, String commitMessage) throws GitLabApiException {
        if (filePath == null) {
            throw new RuntimeException("filePath cannot be null");
        }
        Form form = new Form();
        this.addFormParam(form, "branch", branchName != null ? this.urlEncode(branchName) : null, true);
        this.addFormParam(form, "commit_message", commitMessage, true);
        this.delete(Response.Status.NO_CONTENT, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
    }

    public File getRawFile(Object projectIdOrPath, String commitOrBranchName, String filepath, File directory) throws GitLabApiException {
        InputStream in = this.getRawFile(projectIdOrPath, commitOrBranchName, filepath);
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = new File(filepath).getName();
            File file = new File(directory, filename);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = file;
            return file2;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputStream getRawFile(Object projectIdOrPath, String ref, String filepath) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref != null ? ref : null, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filepath), "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    protected Form createForm(RepositoryFile file, String branchName, String commitMessage) {
        Form form = new Form();
        this.addFormParam(form, "branch", branchName, true);
        this.addFormParam(form, "encoding", (Object)file.getEncoding(), false);
        String content = file.getContent();
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        form.param("content", content);
        this.addFormParam(form, "commit_message", commitMessage, true);
        return form;
    }

    public List<Blame> getBlame(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getBlame(projectIdOrPath, filePath, ref, this.getDefaultPerPage()).all();
    }

    public Pager<Blame> getBlame(Object projectIdOrPath, String filePath, String ref, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref, true);
        return new Pager<Blame>(this, Blame.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath), "blame");
    }

    public Stream<Blame> getBlameStream(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getBlame(projectIdOrPath, filePath, ref, this.getDefaultPerPage()).stream();
    }
}

