/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.SystemHook;

public class SystemHooksApi
extends AbstractApi {
    public SystemHooksApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<SystemHook> getSystemHooks() throws GitLabApiException {
        return this.getSystemHooks(this.getDefaultPerPage()).all();
    }

    public List<SystemHook> getSystemHooks(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "hooks");
        return (List)response.readEntity((GenericType)new GenericType<List<SystemHook>>(this){});
    }

    public Pager<SystemHook> getSystemHooks(int itemsPerPage) throws GitLabApiException {
        return new Pager<SystemHook>(this, SystemHook.class, itemsPerPage, null, "hooks");
    }

    public Stream<SystemHook> getSystemHookStream() throws GitLabApiException {
        return this.getSystemHooks(this.getDefaultPerPage()).stream();
    }

    public SystemHook getSystemHook(Long hookId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "hooks", hookId);
        return (SystemHook)response.readEntity(SystemHook.class);
    }

    public SystemHook addSystemHook(String url, String token, Boolean pushEvents, Boolean tagPushEvents, Boolean enableSslVerification) throws GitLabApiException {
        SystemHook systemHook = new SystemHook().withPushEvents(pushEvents).withTagPushEvents(tagPushEvents).withEnableSslVerification(enableSslVerification);
        return this.addSystemHook(url, token, systemHook);
    }

    public SystemHook addSystemHook(String url, String token, SystemHook systemHook) throws GitLabApiException {
        if (url == null) {
            throw new RuntimeException("url cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("url", url, true).withParam("token", token).withParam("name", systemHook.getName()).withParam("description", systemHook.getDescription()).withParam("push_events", systemHook.getPushEvents()).withParam("tag_push_events", systemHook.getTagPushEvents()).withParam("merge_requests_events", systemHook.getMergeRequestsEvents()).withParam("repository_update_events", systemHook.getRepositoryUpdateEvents()).withParam("enable_ssl_verification", systemHook.getEnableSslVerification());
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"hooks"});
        return (SystemHook)response.readEntity(SystemHook.class);
    }

    public SystemHook updateSystemHook(SystemHook systemHook, String token) throws GitLabApiException {
        if (systemHook.getId() == null) {
            throw new RuntimeException("systemHook id cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("url", systemHook.getUrl()).withParam("token", token).withParam("name", systemHook.getName()).withParam("description", systemHook.getDescription()).withParam("push_events", systemHook.getPushEvents()).withParam("tag_push_events", systemHook.getTagPushEvents()).withParam("merge_requests_events", systemHook.getMergeRequestsEvents()).withParam("repository_update_events", systemHook.getRepositoryUpdateEvents()).withParam("enable_ssl_verification", systemHook.getEnableSslVerification());
        Response response = this.putWithFormData(Response.Status.OK, formData, "hooks", systemHook.getId());
        return (SystemHook)response.readEntity(SystemHook.class);
    }

    public void deleteSystemHook(SystemHook hook) throws GitLabApiException {
        if (hook == null) {
            throw new RuntimeException("hook cannot be null");
        }
        this.deleteSystemHook(hook.getId());
    }

    public void deleteSystemHook(Long hookId) throws GitLabApiException {
        if (hookId == null) {
            throw new RuntimeException("hookId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "hooks", hookId);
    }

    public void testSystemHook(SystemHook hook) throws GitLabApiException {
        if (hook == null) {
            throw new RuntimeException("hook cannot be null");
        }
        this.testSystemHook(hook.getId());
    }

    public void testSystemHook(Long hookId) throws GitLabApiException {
        if (hookId == null) {
            throw new RuntimeException("hookId cannot be null");
        }
        this.get(Response.Status.OK, null, "hooks", hookId);
    }

    public void addSystemHookUrlVariable(Long hookId, String key, String value) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value, true);
        this.put(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"hooks", hookId, "url_variables", key});
    }

    public void deleteSystemHookUrlVariable(Long hookId, String key) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "hooks", hookId, "url_variables", key);
    }
}

