/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.models.PersonalAccessToken;
import org.miaixz.bus.gitlab.support.ISO8601;

public class PersonalAccessTokenApi
extends AbstractApi {
    public PersonalAccessTokenApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public PersonalAccessToken rotatePersonalAccessToken() throws GitLabApiException {
        return this.rotatePersonalAccessToken(null);
    }

    public PersonalAccessToken rotatePersonalAccessToken(Date expiresAt) throws GitLabApiException {
        return this.rotatePersonalAccessToken("self", expiresAt);
    }

    public PersonalAccessToken rotatePersonalAccessToken(String id, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("expires_at", ISO8601.dateOnly(expiresAt));
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"personal_access_tokens", id, "rotate"});
        return (PersonalAccessToken)response.readEntity(PersonalAccessToken.class);
    }

    public List<PersonalAccessToken> getPersonalAccessTokens() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "personal_access_tokens");
        return (List)response.readEntity((GenericType)new GenericType<List<PersonalAccessToken>>(this){});
    }

    public PersonalAccessToken getPersonalAccessToken() throws GitLabApiException {
        return this.getPersonalAccessToken("self");
    }

    public PersonalAccessToken getPersonalAccessToken(String id) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "personal_access_tokens", id);
        return (PersonalAccessToken)response.readEntity(PersonalAccessToken.class);
    }

    public void revokePersonalAccessToken(Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "personal_access_tokens", tokenId);
    }
}

