/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.gitlab;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.miaixz.bus.gitlab.AbstractApi;
import org.miaixz.bus.gitlab.GitLabApi;
import org.miaixz.bus.gitlab.GitLabApiException;
import org.miaixz.bus.gitlab.GitLabApiForm;
import org.miaixz.bus.gitlab.Pager;
import org.miaixz.bus.gitlab.models.AuditEvent;
import org.miaixz.bus.gitlab.support.ISO8601;

public class AuditEventApi
extends AbstractApi {
    public AuditEventApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<AuditEvent> getAuditEvents(Date createdAfter, Date createdBefore, String entityType, Long entityId) throws GitLabApiException {
        return this.getAuditEvents(createdAfter, createdBefore, entityType, entityId, this.getDefaultPerPage()).all();
    }

    public Pager<AuditEvent> getAuditEvents(Date created_after, Date created_before, String entityType, Long entityId, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("created_before", ISO8601.toString(created_before, false)).withParam("created_after", ISO8601.toString(created_after, false)).withParam("entity_type", entityType).withParam("entity_id", entityId);
        return new Pager<AuditEvent>(this, AuditEvent.class, itemsPerPage, (MultivaluedMap<String, String>)form.asMap(), "audit_events");
    }

    public Stream<AuditEvent> getAuditEventsStream(Date createdAfter, Date createdBefore, String entityType, Long entityId) throws GitLabApiException {
        return this.getAuditEvents(createdAfter, createdBefore, entityType, entityId, this.getDefaultPerPage()).stream();
    }

    public AuditEvent getAuditEvent(Long auditEventId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "audit_events", auditEventId);
        return (AuditEvent)response.readEntity(AuditEvent.class);
    }
}

