/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http;

import java.io.EOFException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.http.Cookie;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.UnoUrl;
import org.miaixz.bus.http.metric.CookieJar;
import org.miaixz.bus.http.secure.Challenge;

public class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    private static String get(String[] namesAndValues, String name) {
        for (int i = namesAndValues.length - 2; i >= 0; i -= 2) {
            if (!name.equalsIgnoreCase(namesAndValues[i])) continue;
            return namesAndValues[i + 1];
        }
        return null;
    }

    public static Headers of(String ... namesAndValues) {
        int i;
        if (namesAndValues == null) {
            throw new NullPointerException("namesAndValues == null");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        namesAndValues = (String[])namesAndValues.clone();
        for (i = 0; i < namesAndValues.length; ++i) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            namesAndValues[i] = namesAndValues[i].trim();
        }
        for (i = 0; i < namesAndValues.length; i += 2) {
            String name = namesAndValues[i];
            String value = namesAndValues[i + 1];
            Headers.checkName(name);
            Headers.checkValue(value, name);
        }
        return new Headers(namesAndValues);
    }

    public static Headers of(Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        String[] namesAndValues = new String[headers.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (null == header.getKey() || null == header.getValue()) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String name = header.getKey().trim();
            String value = header.getValue().trim();
            Headers.checkName(name);
            Headers.checkValue(value, name);
            namesAndValues[i] = name;
            namesAndValues[i + 1] = value;
            i += 2;
        }
        return new Headers(namesAndValues);
    }

    static void checkName(String name) {
        if (null == name) {
            throw new NullPointerException("name == null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c > ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header name: %s", c, i, name));
        }
    }

    static void checkValue(String value, String name) {
        if (null == value) {
            throw new NullPointerException("value for name " + name + " == null");
        }
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if ((c > '\u001f' || c == '\t') && c < '\u007f') continue;
            throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in %s value: %s", c, i, name, value));
        }
    }

    public static long contentLength(Response response) {
        return Headers.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return Headers.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
        for (String field : Headers.varyFields(cachedResponse)) {
            if (Objects.equals(cachedRequest.values(field), newRequest.headers(field))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return Headers.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers responseHeaders) {
        return Headers.varyFields(responseHeaders).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return Headers.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers responseHeaders) {
        Set<String> result = Collections.emptySet();
        int size = responseHeaders.size();
        for (int i = 0; i < size; ++i) {
            if (!"Vary".equalsIgnoreCase(responseHeaders.name(i))) continue;
            String value = responseHeaders.value(i);
            if (result.isEmpty()) {
                result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String varyField : value.split(",")) {
                result.add(varyField.trim());
            }
        }
        return result;
    }

    public static Headers varyHeaders(Response response) {
        Headers requestHeaders = response.networkResponse().request().headers();
        Headers responseHeaders = response.headers();
        return Headers.varyHeaders(requestHeaders, responseHeaders);
    }

    public static Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
        Set<String> varyFields = Headers.varyFields(responseHeaders);
        if (varyFields.isEmpty()) {
            return org.miaixz.bus.http.Builder.EMPTY_HEADERS;
        }
        Builder result = new Builder();
        int size = requestHeaders.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = requestHeaders.name(i);
            if (!varyFields.contains(fieldName)) continue;
            result.add(fieldName, requestHeaders.value(i));
        }
        return result.build();
    }

    public static List<Challenge> parseChallenges(Headers responseHeaders, String headerName) {
        ArrayList<Challenge> result = new ArrayList<Challenge>();
        for (int h = 0; h < responseHeaders.size(); ++h) {
            if (!headerName.equalsIgnoreCase(responseHeaders.name(h))) continue;
            Buffer header = new Buffer().writeUtf8(responseHeaders.value(h));
            Headers.parseChallengeHeader(result, header);
        }
        return result;
    }

    private static void parseChallengeHeader(List<Challenge> result, Buffer header) {
        String peek = null;
        while (true) {
            LinkedHashMap<String, String> parameters;
            String schemeName;
            block11: {
                if (peek == null) {
                    Headers.skipWhitespaceAndCommas(header);
                    peek = Headers.readToken(header);
                    if (peek == null) {
                        return;
                    }
                }
                schemeName = peek;
                boolean commaPrefixed = Headers.skipWhitespaceAndCommas(header);
                peek = Headers.readToken(header);
                if (peek == null) {
                    if (!header.exhausted()) {
                        return;
                    }
                    result.add(new Challenge(schemeName, Collections.emptyMap()));
                    return;
                }
                int eqCount = Headers.skipAll(header, (byte)61);
                boolean commaSuffixed = Headers.skipWhitespaceAndCommas(header);
                if (!commaPrefixed && (commaSuffixed || header.exhausted())) {
                    result.add(new Challenge(schemeName, Collections.singletonMap(null, peek + Headers.repeat('=', eqCount))));
                    peek = null;
                    continue;
                }
                parameters = new LinkedHashMap<String, String>();
                eqCount += Headers.skipAll(header, (byte)61);
                do {
                    String parameterValue;
                    if (peek == null) {
                        peek = Headers.readToken(header);
                        if (Headers.skipWhitespaceAndCommas(header)) break block11;
                        eqCount = Headers.skipAll(header, (byte)61);
                    }
                    if (eqCount == 0) break block11;
                    if (eqCount > 1) {
                        return;
                    }
                    if (Headers.skipWhitespaceAndCommas(header)) {
                        return;
                    }
                    String string = parameterValue = !header.exhausted() && header.getByte(0L) == 34 ? Headers.readQuotedString(header) : Headers.readToken(header);
                    if (parameterValue == null) {
                        return;
                    }
                    String replaced = parameters.put(peek, parameterValue);
                    peek = null;
                    if (replaced == null) continue;
                    return;
                } while (Headers.skipWhitespaceAndCommas(header) || header.exhausted());
                return;
            }
            result.add(new Challenge(schemeName, parameters));
        }
    }

    private static boolean skipWhitespaceAndCommas(Buffer buffer) {
        boolean commaFound = false;
        while (!buffer.exhausted()) {
            byte b = buffer.getByte(0L);
            if (b == 44) {
                buffer.readByte();
                commaFound = true;
                continue;
            }
            if (b != 32 && b != 9) break;
            buffer.readByte();
        }
        return commaFound;
    }

    private static int skipAll(Buffer buffer, byte b) {
        int count = 0;
        while (!buffer.exhausted() && buffer.getByte(0L) == b) {
            ++count;
            buffer.readByte();
        }
        return count;
    }

    private static String readQuotedString(Buffer buffer) {
        if (buffer.readByte() != 34) {
            throw new IllegalArgumentException();
        }
        Buffer result = new Buffer();
        long i;
        while ((i = buffer.indexOfElement(org.miaixz.bus.http.Builder.QUOTED_STRING_DELIMITERS)) != -1L) {
            if (buffer.getByte(i) == 34) {
                result.write(buffer, i);
                buffer.readByte();
                return result.readUtf8();
            }
            if (buffer.size() == i + 1L) {
                return null;
            }
            result.write(buffer, i);
            buffer.readByte();
            result.write(buffer, 1L);
        }
        return null;
    }

    private static String readToken(Buffer buffer) {
        try {
            long tokenSize = buffer.indexOfElement(org.miaixz.bus.http.Builder.TOKEN_DELIMITERS);
            if (tokenSize == -1L) {
                tokenSize = buffer.size();
            }
            return tokenSize != 0L ? buffer.readUtf8(tokenSize) : null;
        }
        catch (EOFException e) {
            throw new AssertionError();
        }
    }

    private static String repeat(char c, int count) {
        char[] array = new char[count];
        Arrays.fill(array, c);
        return new String(array);
    }

    public static void receiveHeaders(CookieJar cookieJar, UnoUrl url, Headers headers) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> cookies = Cookie.parseAll(url, headers);
        if (cookies.isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(url, cookies);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int responseCode = response.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return Headers.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    public static int skipUntil(String input, int pos, String characters) {
        while (pos < input.length() && characters.indexOf(input.charAt(pos)) == -1) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespace(String input, int pos) {
        char c;
        while (pos < input.length() && ((c = input.charAt(pos)) == ' ' || c == '\t')) {
            ++pos;
        }
        return pos;
    }

    public static int parseSeconds(String value, int defaultValue) {
        try {
            long seconds = Long.parseLong(value);
            if (seconds > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (seconds < 0L) {
                return 0;
            }
            return (int)seconds;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        Collections.addAll(result.namesAndValues, this.namesAndValues);
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String get(String name) {
        return Headers.get(this.namesAndValues, name);
    }

    public Date getDate(String name) {
        String value = this.get(name);
        return value != null ? org.miaixz.bus.http.Builder.parse(value) : null;
    }

    public Instant getInstant(String name) {
        Date value = this.getDate(name);
        return value != null ? value.toInstant() : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int index) {
        return this.namesAndValues[index * 2];
    }

    public String value(int index) {
        return this.namesAndValues[index * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result.add(this.name(i));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> values(String name) {
        ArrayList<String> result = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equalsIgnoreCase(this.name(i))) continue;
            if (result == null) {
                result = new ArrayList<String>(2);
            }
            result.add(this.value(i));
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    public long byteCount() {
        long result = this.namesAndValues.length * 2;
        int size = this.namesAndValues.length;
        for (int i = 0; i < size; ++i) {
            result += (long)this.namesAndValues[i].length();
        }
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof Headers && Arrays.equals(((Headers)other).namesAndValues, this.namesAndValues);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result.append(this.name(i)).append(": ").append(this.value(i)).append("\n");
        }
        return result.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String name = this.name(i).toLowerCase(Locale.US);
            ArrayList<String> values = (ArrayList<String>)result.get(name);
            if (null == values) {
                values = new ArrayList<String>(2);
                result.put(name, values);
            }
            values.add(this.value(i));
        }
        return result;
    }

    public static class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        public Builder addLenient(String line) {
            int index = line.indexOf(":", 1);
            if (index != -1) {
                return this.addLenient(line.substring(0, index), line.substring(index + 1));
            }
            if (line.startsWith(":")) {
                return this.addLenient("", line.substring(1));
            }
            return this.addLenient("", line);
        }

        public Builder add(String line) {
            int index = line.indexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Unexpected header: " + line);
            }
            return this.add(line.substring(0, index).trim(), line.substring(index + 1));
        }

        public Builder add(String name, String value) {
            Headers.checkName(name);
            Headers.checkValue(value, name);
            return this.addLenient(name, value);
        }

        public Builder addUnsafeNonAscii(String name, String value) {
            Headers.checkName(name);
            return this.addLenient(name, value);
        }

        public Builder addAll(Headers headers) {
            int size = headers.size();
            for (int i = 0; i < size; ++i) {
                this.addLenient(headers.name(i), headers.value(i));
            }
            return this;
        }

        public Builder add(String name, Date value) {
            if (value == null) {
                throw new NullPointerException("value for name " + name + " == null");
            }
            this.add(name, org.miaixz.bus.http.Builder.format(value));
            return this;
        }

        public Builder add(String name, Instant value) {
            if (value == null) {
                throw new NullPointerException("value for name " + name + " == null");
            }
            return this.add(name, new Date(value.toEpochMilli()));
        }

        public Builder set(String name, Date value) {
            if (value == null) {
                throw new NullPointerException("value for name " + name + " == null");
            }
            this.set(name, org.miaixz.bus.http.Builder.format(value));
            return this;
        }

        public Builder set(String name, Instant value) {
            if (value == null) {
                throw new NullPointerException("value for name " + name + " == null");
            }
            return this.set(name, new Date(value.toEpochMilli()));
        }

        Builder addLenient(String name, String value) {
            this.namesAndValues.add(name);
            this.namesAndValues.add(value.trim());
            return this;
        }

        public Builder removeAll(String name) {
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                this.namesAndValues.remove(i);
                this.namesAndValues.remove(i);
                i -= 2;
            }
            return this;
        }

        public Builder set(String name, String value) {
            Headers.checkName(name);
            Headers.checkValue(value, name);
            this.removeAll(name);
            this.addLenient(name, value);
            return this;
        }

        public String get(String name) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }

    public static class Header {
        public static final ByteString PSEUDO_PREFIX = ByteString.encodeUtf8((String)":");
        public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8((String)":status");
        public static final ByteString TARGET_METHOD = ByteString.encodeUtf8((String)":method");
        public static final ByteString TARGET_PATH = ByteString.encodeUtf8((String)":path");
        public static final ByteString TARGET_SCHEME = ByteString.encodeUtf8((String)":scheme");
        public static final ByteString TARGET_AUTHORITY = ByteString.encodeUtf8((String)":authority");
        public final ByteString name;
        public final ByteString value;
        public final int hpackSize;

        public Header(String name, String value) {
            this(ByteString.encodeUtf8((String)name), ByteString.encodeUtf8((String)value));
        }

        public Header(ByteString name, String value) {
            this(name, ByteString.encodeUtf8((String)value));
        }

        public Header(ByteString name, ByteString value) {
            this.name = name;
            this.value = value;
            this.hpackSize = 32 + name.size() + value.size();
        }

        public boolean equals(Object other) {
            if (other instanceof Header) {
                Header that = (Header)other;
                return this.name.equals((Object)that.name) && this.value.equals((Object)that.value);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s: %s", this.name.utf8(), this.value.utf8());
        }
    }
}

