/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.bodys.MultipartBody;
import org.miaixz.bus.http.plugin.httpz.PostRequest;
import org.miaixz.bus.http.plugin.httpz.PutRequest;
import org.miaixz.bus.http.plugin.httpz.RequestBuilder;
import org.miaixz.bus.http.plugin.httpz.RequestCall;

public class PutBuilder
extends RequestBuilder<PutBuilder> {
    private List<PostRequest.FileInfo> fileInfos = new ArrayList<PostRequest.FileInfo>();
    private String body;
    private MultipartBody multipartBody;

    public PutBuilder(Httpd httpd) {
        super(httpd);
    }

    @Override
    public RequestCall build() {
        return new PutRequest(this.url, this.tag, this.params, this.headers, this.fileInfos, this.body, this.multipartBody, this.id).build(this.httpd);
    }

    public PutBuilder body(String body) {
        this.body = body;
        return this;
    }

    public PutBuilder multipartBody(MultipartBody multipartBody) {
        this.multipartBody = multipartBody;
        return this;
    }

    public PutBuilder addFile(String partName, String fileName, byte[] content) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.fileContent = content;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PutBuilder addFile(String partName, String fileName, File file) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.file = file;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PutBuilder addFile(String partName, String fileName, String content) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content, "UTF-8");
    }

    public PutBuilder addFile(String partName, String fileName, String content, String charsetName) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content.getBytes(charsetName));
    }

    public PutBuilder addFile(String partName, String fileName, byte[] content, String charsetName) {
        return this.addFile(partName, fileName, content);
    }
}

