/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.accord;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.miaixz.bus.core.Version;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.sink.Sink;
import org.miaixz.bus.core.io.source.BufferSource;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.exception.RevisedException;
import org.miaixz.bus.core.net.tls.TrustAnyHostnameVerifier;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Address;
import org.miaixz.bus.http.Builder;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.Protocol;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.Route;
import org.miaixz.bus.http.UnoUrl;
import org.miaixz.bus.http.accord.Connection;
import org.miaixz.bus.http.accord.ConnectionSelector;
import org.miaixz.bus.http.accord.ConnectionSuite;
import org.miaixz.bus.http.accord.Exchange;
import org.miaixz.bus.http.accord.RealConnectionPool;
import org.miaixz.bus.http.accord.RouteException;
import org.miaixz.bus.http.accord.Transmitter;
import org.miaixz.bus.http.accord.platform.Platform;
import org.miaixz.bus.http.metric.EventListener;
import org.miaixz.bus.http.metric.Interceptor;
import org.miaixz.bus.http.metric.Internal;
import org.miaixz.bus.http.metric.http.ErrorCode;
import org.miaixz.bus.http.metric.http.Http1Codec;
import org.miaixz.bus.http.metric.http.Http2Codec;
import org.miaixz.bus.http.metric.http.Http2Connection;
import org.miaixz.bus.http.metric.http.Http2Stream;
import org.miaixz.bus.http.metric.http.HttpCodec;
import org.miaixz.bus.http.metric.http.StreamException;
import org.miaixz.bus.http.secure.CertificatePinner;
import org.miaixz.bus.http.socket.Handshake;
import org.miaixz.bus.http.socket.RealWebSocket;

public class RealConnection
extends Http2Connection.Listener
implements Connection {
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    public final RealConnectionPool connectionPool;
    final List<Reference<Transmitter>> transmitters = new ArrayList<Reference<Transmitter>>();
    private final Route route;
    boolean noNewExchanges;
    int routeFailureCount;
    int successCount;
    long idleAtNanos = Long.MAX_VALUE;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferSource source;
    private BufferSink sink;
    private int refusedStreamCount;
    private int allocationLimit = 1;

    public RealConnection(RealConnectionPool connectionPool, Route route) {
        this.connectionPool = connectionPool;
        this.route = route;
    }

    static RealConnection testConnection(RealConnectionPool connectionPool, Route route, Socket socket, long idleAtNanos) {
        RealConnection result = new RealConnection(connectionPool, route);
        result.socket = socket;
        result.idleAtNanos = idleAtNanos;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noNewExchanges() {
        assert (!Thread.holdsLock(this.connectionPool));
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.noNewExchanges = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, NewCall call, EventListener eventListener) {
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        List<ConnectionSuite> connectionSuites = this.route.address().connectionSpecs();
        ConnectionSelector connectionSelector = new ConnectionSelector(connectionSuites);
        if (this.route.address().sslSocketFactory() == null) {
            if (!connectionSuites.contains(ConnectionSuite.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            String host = this.route.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted(host)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + host + " not permitted by network security policy"));
            }
        } else if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new RouteException(new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        }
        while (true) {
            try {
                if (this.route.requiresTunnel()) {
                    this.connectTunnel(connectTimeout, readTimeout, writeTimeout, call, eventListener);
                    if (null == this.rawSocket) {
                        break;
                    }
                } else {
                    this.connectSocket(connectTimeout, readTimeout, call, eventListener);
                }
                this.establishProtocol(connectionSelector, pingIntervalMillis, call, eventListener);
                eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), this.protocol);
            }
            catch (IOException e) {
                IoKit.close((Socket)this.socket);
                IoKit.close((Socket)this.rawSocket);
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                this.http2Connection = null;
                eventListener.connectFailed(call, this.route.socketAddress(), this.route.proxy(), null, e);
                if (null == routeException) {
                    routeException = new RouteException(e);
                    continue;
                }
                routeException.addConnectException(e);
                if (connectionRetryEnabled && connectionSelector.connectionFailed(e)) continue;
                throw routeException;
            }
            break;
        }
        if (this.route.requiresTunnel() && null == this.rawSocket) {
            ProtocolException exception = new ProtocolException("Too many tunnel connections attempted: 21");
            throw new RouteException(exception);
        }
        if (null != this.http2Connection) {
            RealConnectionPool realConnectionPool = this.connectionPool;
            synchronized (realConnectionPool) {
                this.allocationLimit = this.http2Connection.maxConcurrentStreams();
            }
        }
    }

    private void connectTunnel(int connectTimeout, int readTimeout, int writeTimeout, NewCall call, EventListener eventListener) throws IOException {
        Request tunnelRequest = this.createTunnelRequest();
        UnoUrl url = tunnelRequest.url();
        for (int i = 0; i < 21; ++i) {
            this.connectSocket(connectTimeout, readTimeout, call, eventListener);
            tunnelRequest = this.createTunnel(readTimeout, writeTimeout, tunnelRequest, url);
            if (null == tunnelRequest) break;
            IoKit.close((Socket)this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), null);
        }
    }

    private void connectSocket(int connectTimeout, int readTimeout, NewCall call, EventListener eventListener) throws IOException {
        block4: {
            Proxy proxy = this.route.proxy();
            Address address = this.route.address();
            this.rawSocket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.socketFactory().createSocket() : new Socket(proxy);
            eventListener.connectStart(call, this.route.socketAddress(), proxy);
            this.rawSocket.setSoTimeout(readTimeout);
            try {
                Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), connectTimeout);
            }
            catch (ConnectException e) {
                ConnectException ce = new ConnectException("Failed to connect to " + String.valueOf(this.route.socketAddress()));
                ce.initCause(e);
                throw ce;
            }
            try {
                this.source = IoKit.buffer((Source)IoKit.source((Socket)this.rawSocket));
                this.sink = IoKit.buffer((Sink)IoKit.sink((Socket)this.rawSocket));
            }
            catch (NullPointerException npe) {
                if (!NPE_THROW_WITH_NULL.equals(npe.getMessage())) break block4;
                throw new IOException(npe);
            }
        }
    }

    private void establishProtocol(ConnectionSelector connectionSelector, int pingIntervalMillis, NewCall call, EventListener eventListener) throws IOException {
        if (null == this.route.address().sslSocketFactory()) {
            if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                this.socket = this.rawSocket;
                this.protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                this.startHttp2(pingIntervalMillis);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        eventListener.secureConnectStart(call);
        this.connectTls(connectionSelector);
        eventListener.secureConnectEnd(call, this.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(pingIntervalMillis);
        }
    }

    private void startHttp2(int pingIntervalMillis) throws IOException {
        this.socket.setSoTimeout(0);
        this.http2Connection = new Http2Connection.Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).listener(this).pingIntervalMillis(pingIntervalMillis).build();
        this.http2Connection.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectTls(ConnectionSelector connectionSelector) throws IOException {
        Address address = this.route.address();
        SSLSocketFactory sslSocketFactory = address.sslSocketFactory();
        boolean success = false;
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            ConnectionSuite connectionSuite = connectionSelector.configureSecureSocket(sslSocket);
            if (connectionSuite.supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
            }
            sslSocket.startHandshake();
            SSLSession sslSocketSession = sslSocket.getSession();
            Handshake unverifiedHandshake = Handshake.get(sslSocketSession);
            if (!address.hostnameVerifier().verify(address.url().host(), sslSocketSession)) {
                List<Certificate> peerCertificates = unverifiedHandshake.peerCertificates();
                if (peerCertificates.isEmpty()) throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
                X509Certificate cert = (X509Certificate)peerCertificates.get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified:\n    certificate: " + CertificatePinner.pin(cert) + "\n    DN: " + cert.getSubjectX500Principal().getName() + "\n    subjectAltNames: " + String.valueOf(TrustAnyHostnameVerifier.allSubjectAltNames((X509Certificate)cert)));
            }
            address.certificatePinner().check(address.url().host(), unverifiedHandshake.peerCertificates());
            String maybeProtocol = connectionSuite.supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sslSocket) : null;
            this.socket = sslSocket;
            this.source = IoKit.buffer((Source)IoKit.source((Socket)this.socket));
            this.sink = IoKit.buffer((Sink)IoKit.sink((Socket)this.socket));
            this.handshake = unverifiedHandshake;
            this.protocol = null != maybeProtocol ? Protocol.get(maybeProtocol) : Protocol.HTTP_1_1;
            success = true;
            if (null != sslSocket) {
                Platform.get().afterHandshake(sslSocket);
            }
            if (success) return;
        }
        catch (AssertionError e) {
            try {
                if (!IoKit.isAndroidGetsocknameError((AssertionError)e)) throw e;
                throw new IOException((Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                if (null != sslSocket) {
                    Platform.get().afterHandshake(sslSocket);
                }
                if (success) throw throwable;
                IoKit.close(sslSocket);
                throw throwable;
            }
        }
        IoKit.close((Socket)sslSocket);
        return;
    }

    private Request createTunnel(int readTimeout, int writeTimeout, Request tunnelRequest, UnoUrl url) throws IOException {
        Response response;
        String requestLine = "CONNECT " + Builder.hostHeader(url, true) + " HTTP/1.1";
        block4: while (true) {
            Http1Codec tunnelCodec = new Http1Codec(null, null, this.source, this.sink);
            this.source.timeout().timeout((long)readTimeout, TimeUnit.MILLISECONDS);
            this.sink.timeout().timeout((long)writeTimeout, TimeUnit.MILLISECONDS);
            tunnelCodec.writeRequest(tunnelRequest.headers(), requestLine);
            tunnelCodec.finishRequest();
            response = tunnelCodec.readResponseHeaders(false).request(tunnelRequest).build();
            tunnelCodec.skipConnectBody(response);
            switch (response.code()) {
                case 200: {
                    if (!this.source.getBuffer().exhausted() || !this.sink.buffer().exhausted()) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return null;
                }
                case 407: {
                    tunnelRequest = this.route.address().proxyAuthenticator().authenticate(this.route, response);
                    if (null != tunnelRequest) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!"close".equalsIgnoreCase(response.header("Connection"))) continue block4;
                    return tunnelRequest;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private Request createTunnelRequest() throws IOException {
        Request proxyConnectRequest = new Request.Builder().url(this.route.address().url()).method("CONNECT", null).header("Host", Builder.hostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "Httpd/" + Version.all()).build();
        Response fakeAuthChallengeResponse = new Response.Builder().request(proxyConnectRequest).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Builder.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "Httpd-Preemptive").build();
        Request authenticatedRequest = this.route.address().proxyAuthenticator().authenticate(this.route, fakeAuthChallengeResponse);
        return null != authenticatedRequest ? authenticatedRequest : proxyConnectRequest;
    }

    boolean isEligible(Address address, List<Route> routes) {
        if (this.transmitters.size() >= this.allocationLimit || this.noNewExchanges) {
            return false;
        }
        if (!Internal.instance.equalsNonHost(this.route.address(), address)) {
            return false;
        }
        if (address.url().host().equals(this.route().address().url().host())) {
            return true;
        }
        if (null == this.http2Connection) {
            return false;
        }
        if (routes == null || !this.routeMatchesAny(routes)) {
            return false;
        }
        if (address.hostnameVerifier() != TrustAnyHostnameVerifier.INSTANCE) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
        }
        catch (SSLPeerUnverifiedException e) {
            return false;
        }
        return true;
    }

    private boolean routeMatchesAny(List<Route> candidates) {
        int size = candidates.size();
        for (int i = 0; i < size; ++i) {
            Route candidate = candidates.get(i);
            if (candidate.proxy().type() != Proxy.Type.DIRECT || this.route.proxy().type() != Proxy.Type.DIRECT || !this.route.socketAddress().equals(candidate.socketAddress())) continue;
            return true;
        }
        return false;
    }

    public boolean supportsUrl(UnoUrl url) {
        if (url.port() != this.route.address().url().port()) {
            return false;
        }
        if (!url.host().equals(this.route.address().url().host())) {
            return null != this.handshake && TrustAnyHostnameVerifier.INSTANCE.verify(url.host(), (X509Certificate)this.handshake.peerCertificates().get(0));
        }
        return true;
    }

    HttpCodec newCodec(Httpd client, Interceptor.Chain chain) throws SocketException {
        if (this.http2Connection != null) {
            return new Http2Codec(client, this, chain, this.http2Connection);
        }
        this.socket.setSoTimeout(chain.readTimeoutMillis());
        this.source.timeout().timeout((long)chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.sink.timeout().timeout((long)chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        return new Http1Codec(client, this, this.source, this.sink);
    }

    RealWebSocket.Streams newWebSocketStreams(final Exchange exchange) throws SocketException {
        this.socket.setSoTimeout(0);
        this.noNewExchanges();
        return new RealWebSocket.Streams(this, true, this.source, this.sink){

            @Override
            public void close() {
                exchange.bodyComplete(-1L, true, true, null);
            }
        };
    }

    @Override
    public Route route() {
        return this.route;
    }

    public void cancel() {
        IoKit.close((Socket)this.rawSocket);
    }

    @Override
    public Socket socket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHealthy(boolean doExtensiveChecks) {
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        if (null != this.http2Connection) {
            return this.http2Connection.isHealthy(System.nanoTime());
        }
        if (!doExtensiveChecks) return true;
        try {
            int readTimeout222 = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (this.source.exhausted()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.socket.setSoTimeout(readTimeout222);
            }
        }
        catch (SocketTimeoutException readTimeout222) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void onStream(Http2Stream stream) throws IOException {
        stream.close(ErrorCode.REFUSED_STREAM, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettings(Http2Connection connection) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            this.allocationLimit = connection.maxConcurrentStreams();
        }
    }

    @Override
    public Handshake handshake() {
        return this.handshake;
    }

    public boolean isMultiplexed() {
        return this.http2Connection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackFailure(IOException e) {
        assert (!Thread.holdsLock(this.connectionPool));
        RealConnectionPool realConnectionPool = this.connectionPool;
        synchronized (realConnectionPool) {
            if (e instanceof StreamException) {
                ErrorCode errorCode = ((StreamException)((Object)e)).errorCode;
                if (errorCode == ErrorCode.REFUSED_STREAM) {
                    ++this.refusedStreamCount;
                    if (this.refusedStreamCount > 1) {
                        this.noNewExchanges = true;
                        ++this.routeFailureCount;
                    }
                } else if (errorCode != ErrorCode.CANCEL) {
                    this.noNewExchanges = true;
                    ++this.routeFailureCount;
                }
            } else if (!this.isMultiplexed() || e instanceof RevisedException) {
                this.noNewExchanges = true;
                if (this.successCount == 0) {
                    if (e != null) {
                        this.connectionPool.connectFailed(this.route, e);
                    }
                    ++this.routeFailureCount;
                }
            }
        }
    }

    @Override
    public Protocol protocol() {
        return this.protocol;
    }

    public String toString() {
        return "RealConnection{" + this.route.address().url().host() + ":" + this.route.address().url().port() + ", proxy=" + String.valueOf(this.route.proxy()) + " hostAddress=" + String.valueOf(this.route.socketAddress()) + " cipherSuite=" + String.valueOf(null != this.handshake ? this.handshake.cipherSuite() : "none") + " protocol=" + String.valueOf((Object)this.protocol) + "}";
    }
}

